/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.workloadorchestration.WorkloadOrchestrationManager;
import com.azure.resourcemanager.workloadorchestration.fluent.models.InstanceInner;
import com.azure.resourcemanager.workloadorchestration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.workloadorchestration.models.ExtendedLocation;
import com.azure.resourcemanager.workloadorchestration.models.Instance;
import com.azure.resourcemanager.workloadorchestration.models.InstanceProperties;

public final class InstanceImpl
implements Instance,
Instance.Definition,
Instance.Update {
    private InstanceInner innerObject;
    private final WorkloadOrchestrationManager serviceManager;
    private String resourceGroupName;
    private String targetName;
    private String solutionName;
    private String instanceName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public InstanceProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public ExtendedLocation extendedLocation() {
        return this.innerModel().extendedLocation();
    }

    @Override
    public String eTag() {
        return this.innerModel().eTag();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public InstanceInner innerModel() {
        return this.innerObject;
    }

    private WorkloadOrchestrationManager manager() {
        return this.serviceManager;
    }

    @Override
    public InstanceImpl withExistingSolution(String resourceGroupName, String targetName, String solutionName) {
        this.resourceGroupName = resourceGroupName;
        this.targetName = targetName;
        this.solutionName = solutionName;
        return this;
    }

    @Override
    public Instance create() {
        this.innerObject = this.serviceManager.serviceClient().getInstances().createOrUpdate(this.resourceGroupName, this.targetName, this.solutionName, this.instanceName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public Instance create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getInstances().createOrUpdate(this.resourceGroupName, this.targetName, this.solutionName, this.instanceName, this.innerModel(), context);
        return this;
    }

    InstanceImpl(String name, WorkloadOrchestrationManager serviceManager) {
        this.innerObject = new InstanceInner();
        this.serviceManager = serviceManager;
        this.instanceName = name;
    }

    @Override
    public InstanceImpl update() {
        return this;
    }

    @Override
    public Instance apply() {
        this.innerObject = this.serviceManager.serviceClient().getInstances().update(this.resourceGroupName, this.targetName, this.solutionName, this.instanceName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public Instance apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getInstances().update(this.resourceGroupName, this.targetName, this.solutionName, this.instanceName, this.innerModel(), context);
        return this;
    }

    InstanceImpl(InstanceInner innerObject, WorkloadOrchestrationManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.targetName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "targets");
        this.solutionName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "solutions");
        this.instanceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "instances");
    }

    @Override
    public Instance refresh() {
        this.innerObject = (InstanceInner)((Object)this.serviceManager.serviceClient().getInstances().getWithResponse(this.resourceGroupName, this.targetName, this.solutionName, this.instanceName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Instance refresh(Context context) {
        this.innerObject = (InstanceInner)((Object)this.serviceManager.serviceClient().getInstances().getWithResponse(this.resourceGroupName, this.targetName, this.solutionName, this.instanceName, context).getValue());
        return this;
    }

    @Override
    public InstanceImpl withProperties(InstanceProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    @Override
    public InstanceImpl withExtendedLocation(ExtendedLocation extendedLocation) {
        this.innerModel().withExtendedLocation(extendedLocation);
        return this;
    }
}

