/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.workloadorchestration.fluent.ExecutionsClient;
import com.azure.resourcemanager.workloadorchestration.fluent.models.ExecutionInner;
import com.azure.resourcemanager.workloadorchestration.implementation.WorkloadOrchestrationManagementClientImpl;
import com.azure.resourcemanager.workloadorchestration.implementation.models.ExecutionListResult;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ExecutionsClientImpl
implements ExecutionsClient {
    private final ExecutionsService service;
    private final WorkloadOrchestrationManagementClientImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(ExecutionsClientImpl.class);

    ExecutionsClientImpl(WorkloadOrchestrationManagementClientImpl client) {
        this.service = (ExecutionsService)RestProxy.create(ExecutionsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ExecutionInner>> getWithResponseAsync(String resourceGroupName, String contextName, String workflowName, String versionName, String executionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (contextName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter contextName is required and cannot be null."));
        }
        if (workflowName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workflowName is required and cannot be null."));
        }
        if (versionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter versionName is required and cannot be null."));
        }
        if (executionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter executionName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, contextName, workflowName, versionName, executionName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ExecutionInner> getAsync(String resourceGroupName, String contextName, String workflowName, String versionName, String executionName) {
        return this.getWithResponseAsync(resourceGroupName, contextName, workflowName, versionName, executionName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ExecutionInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ExecutionInner> getWithResponse(String resourceGroupName, String contextName, String workflowName, String versionName, String executionName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (contextName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter contextName is required and cannot be null."));
        }
        if (workflowName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter workflowName is required and cannot be null."));
        }
        if (versionName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter versionName is required and cannot be null."));
        }
        if (executionName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter executionName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.getSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, contextName, workflowName, versionName, executionName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ExecutionInner get(String resourceGroupName, String contextName, String workflowName, String versionName, String executionName) {
        return (ExecutionInner)((Object)this.getWithResponse(resourceGroupName, contextName, workflowName, versionName, executionName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String contextName, String workflowName, String versionName, String executionName, ExecutionInner resource) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (contextName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter contextName is required and cannot be null."));
        }
        if (workflowName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workflowName is required and cannot be null."));
        }
        if (versionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter versionName is required and cannot be null."));
        }
        if (executionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter executionName is required and cannot be null."));
        }
        if (resource == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resource is required and cannot be null."));
        }
        resource.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, contextName, workflowName, versionName, executionName, "application/json", "application/json", resource, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String resourceGroupName, String contextName, String workflowName, String versionName, String executionName, ExecutionInner resource) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (contextName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter contextName is required and cannot be null."));
        }
        if (workflowName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter workflowName is required and cannot be null."));
        }
        if (versionName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter versionName is required and cannot be null."));
        }
        if (executionName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter executionName is required and cannot be null."));
        }
        if (resource == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resource is required and cannot be null."));
        }
        resource.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, contextName, workflowName, versionName, executionName, "application/json", "application/json", resource, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String resourceGroupName, String contextName, String workflowName, String versionName, String executionName, ExecutionInner resource, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (contextName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter contextName is required and cannot be null."));
        }
        if (workflowName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter workflowName is required and cannot be null."));
        }
        if (versionName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter versionName is required and cannot be null."));
        }
        if (executionName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter executionName is required and cannot be null."));
        }
        if (resource == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resource is required and cannot be null."));
        }
        resource.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, contextName, workflowName, versionName, executionName, "application/json", "application/json", resource, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ExecutionInner>, ExecutionInner> beginCreateOrUpdateAsync(String resourceGroupName, String contextName, String workflowName, String versionName, String executionName, ExecutionInner resource) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, contextName, workflowName, versionName, executionName, resource);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)ExecutionInner.class), (Type)((Object)ExecutionInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ExecutionInner>, ExecutionInner> beginCreateOrUpdate(String resourceGroupName, String contextName, String workflowName, String versionName, String executionName, ExecutionInner resource) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, contextName, workflowName, versionName, executionName, resource);
        return this.client.getLroResult(response, (Type)((Object)ExecutionInner.class), (Type)((Object)ExecutionInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ExecutionInner>, ExecutionInner> beginCreateOrUpdate(String resourceGroupName, String contextName, String workflowName, String versionName, String executionName, ExecutionInner resource, Context context) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, contextName, workflowName, versionName, executionName, resource, context);
        return this.client.getLroResult(response, (Type)((Object)ExecutionInner.class), (Type)((Object)ExecutionInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ExecutionInner> createOrUpdateAsync(String resourceGroupName, String contextName, String workflowName, String versionName, String executionName, ExecutionInner resource) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, contextName, workflowName, versionName, executionName, resource).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ExecutionInner createOrUpdate(String resourceGroupName, String contextName, String workflowName, String versionName, String executionName, ExecutionInner resource) {
        return (ExecutionInner)((Object)this.beginCreateOrUpdate(resourceGroupName, contextName, workflowName, versionName, executionName, resource).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ExecutionInner createOrUpdate(String resourceGroupName, String contextName, String workflowName, String versionName, String executionName, ExecutionInner resource, Context context) {
        return (ExecutionInner)((Object)this.beginCreateOrUpdate(resourceGroupName, contextName, workflowName, versionName, executionName, resource, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String contextName, String workflowName, String versionName, String executionName, ExecutionInner properties) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (contextName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter contextName is required and cannot be null."));
        }
        if (workflowName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workflowName is required and cannot be null."));
        }
        if (versionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter versionName is required and cannot be null."));
        }
        if (executionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter executionName is required and cannot be null."));
        }
        if (properties == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter properties is required and cannot be null."));
        }
        properties.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, contextName, workflowName, versionName, executionName, "application/json", "application/json", properties, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> updateWithResponse(String resourceGroupName, String contextName, String workflowName, String versionName, String executionName, ExecutionInner properties) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (contextName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter contextName is required and cannot be null."));
        }
        if (workflowName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter workflowName is required and cannot be null."));
        }
        if (versionName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter versionName is required and cannot be null."));
        }
        if (executionName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter executionName is required and cannot be null."));
        }
        if (properties == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter properties is required and cannot be null."));
        }
        properties.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.updateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, contextName, workflowName, versionName, executionName, "application/json", "application/json", properties, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> updateWithResponse(String resourceGroupName, String contextName, String workflowName, String versionName, String executionName, ExecutionInner properties, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (contextName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter contextName is required and cannot be null."));
        }
        if (workflowName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter workflowName is required and cannot be null."));
        }
        if (versionName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter versionName is required and cannot be null."));
        }
        if (executionName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter executionName is required and cannot be null."));
        }
        if (properties == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter properties is required and cannot be null."));
        }
        properties.validate();
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.updateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, contextName, workflowName, versionName, executionName, "application/json", "application/json", properties, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ExecutionInner>, ExecutionInner> beginUpdateAsync(String resourceGroupName, String contextName, String workflowName, String versionName, String executionName, ExecutionInner properties) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, contextName, workflowName, versionName, executionName, properties);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)ExecutionInner.class), (Type)((Object)ExecutionInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ExecutionInner>, ExecutionInner> beginUpdate(String resourceGroupName, String contextName, String workflowName, String versionName, String executionName, ExecutionInner properties) {
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, contextName, workflowName, versionName, executionName, properties);
        return this.client.getLroResult(response, (Type)((Object)ExecutionInner.class), (Type)((Object)ExecutionInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ExecutionInner>, ExecutionInner> beginUpdate(String resourceGroupName, String contextName, String workflowName, String versionName, String executionName, ExecutionInner properties, Context context) {
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, contextName, workflowName, versionName, executionName, properties, context);
        return this.client.getLroResult(response, (Type)((Object)ExecutionInner.class), (Type)((Object)ExecutionInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ExecutionInner> updateAsync(String resourceGroupName, String contextName, String workflowName, String versionName, String executionName, ExecutionInner properties) {
        return this.beginUpdateAsync(resourceGroupName, contextName, workflowName, versionName, executionName, properties).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ExecutionInner update(String resourceGroupName, String contextName, String workflowName, String versionName, String executionName, ExecutionInner properties) {
        return (ExecutionInner)((Object)this.beginUpdate(resourceGroupName, contextName, workflowName, versionName, executionName, properties).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ExecutionInner update(String resourceGroupName, String contextName, String workflowName, String versionName, String executionName, ExecutionInner properties, Context context) {
        return (ExecutionInner)((Object)this.beginUpdate(resourceGroupName, contextName, workflowName, versionName, executionName, properties, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String contextName, String workflowName, String versionName, String executionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (contextName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter contextName is required and cannot be null."));
        }
        if (workflowName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workflowName is required and cannot be null."));
        }
        if (versionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter versionName is required and cannot be null."));
        }
        if (executionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter executionName is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, contextName, workflowName, versionName, executionName, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String contextName, String workflowName, String versionName, String executionName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (contextName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter contextName is required and cannot be null."));
        }
        if (workflowName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter workflowName is required and cannot be null."));
        }
        if (versionName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter versionName is required and cannot be null."));
        }
        if (executionName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter executionName is required and cannot be null."));
        }
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, contextName, workflowName, versionName, executionName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String contextName, String workflowName, String versionName, String executionName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (contextName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter contextName is required and cannot be null."));
        }
        if (workflowName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter workflowName is required and cannot be null."));
        }
        if (versionName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter versionName is required and cannot be null."));
        }
        if (executionName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter executionName is required and cannot be null."));
        }
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, contextName, workflowName, versionName, executionName, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String contextName, String workflowName, String versionName, String executionName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, contextName, workflowName, versionName, executionName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String contextName, String workflowName, String versionName, String executionName) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, contextName, workflowName, versionName, executionName);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String contextName, String workflowName, String versionName, String executionName, Context context) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, contextName, workflowName, versionName, executionName, context);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String contextName, String workflowName, String versionName, String executionName) {
        return this.beginDeleteAsync(resourceGroupName, contextName, workflowName, versionName, executionName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String contextName, String workflowName, String versionName, String executionName) {
        this.beginDelete(resourceGroupName, contextName, workflowName, versionName, executionName).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String contextName, String workflowName, String versionName, String executionName, Context context) {
        this.beginDelete(resourceGroupName, contextName, workflowName, versionName, executionName, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ExecutionInner>> listByWorkflowVersionSinglePageAsync(String resourceGroupName, String contextName, String workflowName, String versionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (contextName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter contextName is required and cannot be null."));
        }
        if (workflowName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter workflowName is required and cannot be null."));
        }
        if (versionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter versionName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByWorkflowVersion(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, contextName, workflowName, versionName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ExecutionListResult)res.getValue()).value(), ((ExecutionListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ExecutionInner> listByWorkflowVersionAsync(String resourceGroupName, String contextName, String workflowName, String versionName) {
        return new PagedFlux(() -> this.listByWorkflowVersionSinglePageAsync(resourceGroupName, contextName, workflowName, versionName), nextLink -> this.listByWorkflowVersionNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<ExecutionInner> listByWorkflowVersionSinglePage(String resourceGroupName, String contextName, String workflowName, String versionName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (contextName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter contextName is required and cannot be null."));
        }
        if (workflowName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter workflowName is required and cannot be null."));
        }
        if (versionName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter versionName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<ExecutionListResult> res = this.service.listByWorkflowVersionSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, contextName, workflowName, versionName, "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ExecutionListResult)res.getValue()).value(), ((ExecutionListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<ExecutionInner> listByWorkflowVersionSinglePage(String resourceGroupName, String contextName, String workflowName, String versionName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (contextName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter contextName is required and cannot be null."));
        }
        if (workflowName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter workflowName is required and cannot be null."));
        }
        if (versionName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter versionName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<ExecutionListResult> res = this.service.listByWorkflowVersionSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, contextName, workflowName, versionName, "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ExecutionListResult)res.getValue()).value(), ((ExecutionListResult)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ExecutionInner> listByWorkflowVersion(String resourceGroupName, String contextName, String workflowName, String versionName) {
        return new PagedIterable(() -> this.listByWorkflowVersionSinglePage(resourceGroupName, contextName, workflowName, versionName), nextLink -> this.listByWorkflowVersionNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ExecutionInner> listByWorkflowVersion(String resourceGroupName, String contextName, String workflowName, String versionName, Context context) {
        return new PagedIterable(() -> this.listByWorkflowVersionSinglePage(resourceGroupName, contextName, workflowName, versionName, context), nextLink -> this.listByWorkflowVersionNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ExecutionInner>> listByWorkflowVersionNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByWorkflowVersionNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ExecutionListResult)res.getValue()).value(), ((ExecutionListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<ExecutionInner> listByWorkflowVersionNextSinglePage(String nextLink) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<ExecutionListResult> res = this.service.listByWorkflowVersionNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ExecutionListResult)res.getValue()).value(), ((ExecutionListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<ExecutionInner> listByWorkflowVersionNextSinglePage(String nextLink, Context context) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<ExecutionListResult> res = this.service.listByWorkflowVersionNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ExecutionListResult)res.getValue()).value(), ((ExecutionListResult)res.getValue()).nextLink(), null);
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="WorkloadOrchestrationManagementClientExecutions")
    public static interface ExecutionsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Edge/contexts/{contextName}/workflows/{workflowName}/versions/{versionName}/executions/{executionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ExecutionInner>> get(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="contextName") String var5, @PathParam(value="workflowName") String var6, @PathParam(value="versionName") String var7, @PathParam(value="executionName") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Edge/contexts/{contextName}/workflows/{workflowName}/versions/{versionName}/executions/{executionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<ExecutionInner> getSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="contextName") String var5, @PathParam(value="workflowName") String var6, @PathParam(value="versionName") String var7, @PathParam(value="executionName") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Edge/contexts/{contextName}/workflows/{workflowName}/versions/{versionName}/executions/{executionName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="contextName") String var5, @PathParam(value="workflowName") String var6, @PathParam(value="versionName") String var7, @PathParam(value="executionName") String var8, @HeaderParam(value="Content-Type") String var9, @HeaderParam(value="Accept") String var10, @BodyParam(value="application/json") ExecutionInner var11, Context var12);

        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Edge/contexts/{contextName}/workflows/{workflowName}/versions/{versionName}/executions/{executionName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> createOrUpdateSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="contextName") String var5, @PathParam(value="workflowName") String var6, @PathParam(value="versionName") String var7, @PathParam(value="executionName") String var8, @HeaderParam(value="Content-Type") String var9, @HeaderParam(value="Accept") String var10, @BodyParam(value="application/json") ExecutionInner var11, Context var12);

        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Edge/contexts/{contextName}/workflows/{workflowName}/versions/{versionName}/executions/{executionName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="contextName") String var5, @PathParam(value="workflowName") String var6, @PathParam(value="versionName") String var7, @PathParam(value="executionName") String var8, @HeaderParam(value="Content-Type") String var9, @HeaderParam(value="Accept") String var10, @BodyParam(value="application/json") ExecutionInner var11, Context var12);

        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Edge/contexts/{contextName}/workflows/{workflowName}/versions/{versionName}/executions/{executionName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> updateSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="contextName") String var5, @PathParam(value="workflowName") String var6, @PathParam(value="versionName") String var7, @PathParam(value="executionName") String var8, @HeaderParam(value="Content-Type") String var9, @HeaderParam(value="Accept") String var10, @BodyParam(value="application/json") ExecutionInner var11, Context var12);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Edge/contexts/{contextName}/workflows/{workflowName}/versions/{versionName}/executions/{executionName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="contextName") String var5, @PathParam(value="workflowName") String var6, @PathParam(value="versionName") String var7, @PathParam(value="executionName") String var8, Context var9);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Edge/contexts/{contextName}/workflows/{workflowName}/versions/{versionName}/executions/{executionName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> deleteSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="contextName") String var5, @PathParam(value="workflowName") String var6, @PathParam(value="versionName") String var7, @PathParam(value="executionName") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Edge/contexts/{contextName}/workflows/{workflowName}/versions/{versionName}/executions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ExecutionListResult>> listByWorkflowVersion(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="contextName") String var5, @PathParam(value="workflowName") String var6, @PathParam(value="versionName") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Edge/contexts/{contextName}/workflows/{workflowName}/versions/{versionName}/executions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<ExecutionListResult> listByWorkflowVersionSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="contextName") String var5, @PathParam(value="workflowName") String var6, @PathParam(value="versionName") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ExecutionListResult>> listByWorkflowVersionNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<ExecutionListResult> listByWorkflowVersionNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

