/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.workloadorchestration.WorkloadOrchestrationManager;
import com.azure.resourcemanager.workloadorchestration.fluent.DynamicSchemasClient;
import com.azure.resourcemanager.workloadorchestration.fluent.models.DynamicSchemaInner;
import com.azure.resourcemanager.workloadorchestration.implementation.DynamicSchemaImpl;
import com.azure.resourcemanager.workloadorchestration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.workloadorchestration.models.DynamicSchema;
import com.azure.resourcemanager.workloadorchestration.models.DynamicSchemas;

public final class DynamicSchemasImpl
implements DynamicSchemas {
    private static final ClientLogger LOGGER = new ClientLogger(DynamicSchemasImpl.class);
    private final DynamicSchemasClient innerClient;
    private final WorkloadOrchestrationManager serviceManager;

    public DynamicSchemasImpl(DynamicSchemasClient innerClient, WorkloadOrchestrationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<DynamicSchema> getWithResponse(String resourceGroupName, String schemaName, String dynamicSchemaName, Context context) {
        Response<DynamicSchemaInner> inner = this.serviceClient().getWithResponse(resourceGroupName, schemaName, dynamicSchemaName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DynamicSchemaImpl((DynamicSchemaInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public DynamicSchema get(String resourceGroupName, String schemaName, String dynamicSchemaName) {
        DynamicSchemaInner inner = this.serviceClient().get(resourceGroupName, schemaName, dynamicSchemaName);
        if (inner != null) {
            return new DynamicSchemaImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String schemaName, String dynamicSchemaName) {
        this.serviceClient().delete(resourceGroupName, schemaName, dynamicSchemaName);
    }

    @Override
    public void delete(String resourceGroupName, String schemaName, String dynamicSchemaName, Context context) {
        this.serviceClient().delete(resourceGroupName, schemaName, dynamicSchemaName, context);
    }

    @Override
    public PagedIterable<DynamicSchema> listBySchema(String resourceGroupName, String schemaName) {
        PagedIterable<DynamicSchemaInner> inner = this.serviceClient().listBySchema(resourceGroupName, schemaName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DynamicSchemaImpl((DynamicSchemaInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<DynamicSchema> listBySchema(String resourceGroupName, String schemaName, Context context) {
        PagedIterable<DynamicSchemaInner> inner = this.serviceClient().listBySchema(resourceGroupName, schemaName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DynamicSchemaImpl((DynamicSchemaInner)((Object)inner1), this.manager()));
    }

    @Override
    public DynamicSchema getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String schemaName = ResourceManagerUtils.getValueFromIdByName(id, "schemas");
        if (schemaName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'schemas'.", id)));
        }
        String dynamicSchemaName = ResourceManagerUtils.getValueFromIdByName(id, "dynamicSchemas");
        if (dynamicSchemaName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dynamicSchemas'.", id)));
        }
        return (DynamicSchema)this.getWithResponse(resourceGroupName, schemaName, dynamicSchemaName, Context.NONE).getValue();
    }

    @Override
    public Response<DynamicSchema> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String schemaName = ResourceManagerUtils.getValueFromIdByName(id, "schemas");
        if (schemaName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'schemas'.", id)));
        }
        String dynamicSchemaName = ResourceManagerUtils.getValueFromIdByName(id, "dynamicSchemas");
        if (dynamicSchemaName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dynamicSchemas'.", id)));
        }
        return this.getWithResponse(resourceGroupName, schemaName, dynamicSchemaName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String schemaName = ResourceManagerUtils.getValueFromIdByName(id, "schemas");
        if (schemaName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'schemas'.", id)));
        }
        String dynamicSchemaName = ResourceManagerUtils.getValueFromIdByName(id, "dynamicSchemas");
        if (dynamicSchemaName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dynamicSchemas'.", id)));
        }
        this.delete(resourceGroupName, schemaName, dynamicSchemaName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String schemaName = ResourceManagerUtils.getValueFromIdByName(id, "schemas");
        if (schemaName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'schemas'.", id)));
        }
        String dynamicSchemaName = ResourceManagerUtils.getValueFromIdByName(id, "dynamicSchemas");
        if (dynamicSchemaName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dynamicSchemas'.", id)));
        }
        this.delete(resourceGroupName, schemaName, dynamicSchemaName, context);
    }

    private DynamicSchemasClient serviceClient() {
        return this.innerClient;
    }

    private WorkloadOrchestrationManager manager() {
        return this.serviceManager;
    }

    @Override
    public DynamicSchemaImpl define(String name) {
        return new DynamicSchemaImpl(name, this.manager());
    }
}

