/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.workloadorchestration.WorkloadOrchestrationManager;
import com.azure.resourcemanager.workloadorchestration.fluent.DynamicSchemaVersionsClient;
import com.azure.resourcemanager.workloadorchestration.fluent.models.DynamicSchemaVersionInner;
import com.azure.resourcemanager.workloadorchestration.implementation.DynamicSchemaVersionImpl;
import com.azure.resourcemanager.workloadorchestration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.workloadorchestration.models.DynamicSchemaVersion;
import com.azure.resourcemanager.workloadorchestration.models.DynamicSchemaVersions;

public final class DynamicSchemaVersionsImpl
implements DynamicSchemaVersions {
    private static final ClientLogger LOGGER = new ClientLogger(DynamicSchemaVersionsImpl.class);
    private final DynamicSchemaVersionsClient innerClient;
    private final WorkloadOrchestrationManager serviceManager;

    public DynamicSchemaVersionsImpl(DynamicSchemaVersionsClient innerClient, WorkloadOrchestrationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<DynamicSchemaVersion> getWithResponse(String resourceGroupName, String schemaName, String dynamicSchemaName, String dynamicSchemaVersionName, Context context) {
        Response<DynamicSchemaVersionInner> inner = this.serviceClient().getWithResponse(resourceGroupName, schemaName, dynamicSchemaName, dynamicSchemaVersionName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DynamicSchemaVersionImpl((DynamicSchemaVersionInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public DynamicSchemaVersion get(String resourceGroupName, String schemaName, String dynamicSchemaName, String dynamicSchemaVersionName) {
        DynamicSchemaVersionInner inner = this.serviceClient().get(resourceGroupName, schemaName, dynamicSchemaName, dynamicSchemaVersionName);
        if (inner != null) {
            return new DynamicSchemaVersionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String schemaName, String dynamicSchemaName, String dynamicSchemaVersionName) {
        this.serviceClient().delete(resourceGroupName, schemaName, dynamicSchemaName, dynamicSchemaVersionName);
    }

    @Override
    public void delete(String resourceGroupName, String schemaName, String dynamicSchemaName, String dynamicSchemaVersionName, Context context) {
        this.serviceClient().delete(resourceGroupName, schemaName, dynamicSchemaName, dynamicSchemaVersionName, context);
    }

    @Override
    public PagedIterable<DynamicSchemaVersion> listByDynamicSchema(String resourceGroupName, String schemaName, String dynamicSchemaName) {
        PagedIterable<DynamicSchemaVersionInner> inner = this.serviceClient().listByDynamicSchema(resourceGroupName, schemaName, dynamicSchemaName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DynamicSchemaVersionImpl((DynamicSchemaVersionInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<DynamicSchemaVersion> listByDynamicSchema(String resourceGroupName, String schemaName, String dynamicSchemaName, Context context) {
        PagedIterable<DynamicSchemaVersionInner> inner = this.serviceClient().listByDynamicSchema(resourceGroupName, schemaName, dynamicSchemaName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DynamicSchemaVersionImpl((DynamicSchemaVersionInner)((Object)inner1), this.manager()));
    }

    @Override
    public DynamicSchemaVersion getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String schemaName = ResourceManagerUtils.getValueFromIdByName(id, "schemas");
        if (schemaName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'schemas'.", id)));
        }
        String dynamicSchemaName = ResourceManagerUtils.getValueFromIdByName(id, "dynamicSchemas");
        if (dynamicSchemaName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dynamicSchemas'.", id)));
        }
        String dynamicSchemaVersionName = ResourceManagerUtils.getValueFromIdByName(id, "versions");
        if (dynamicSchemaVersionName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'versions'.", id)));
        }
        return (DynamicSchemaVersion)this.getWithResponse(resourceGroupName, schemaName, dynamicSchemaName, dynamicSchemaVersionName, Context.NONE).getValue();
    }

    @Override
    public Response<DynamicSchemaVersion> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String schemaName = ResourceManagerUtils.getValueFromIdByName(id, "schemas");
        if (schemaName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'schemas'.", id)));
        }
        String dynamicSchemaName = ResourceManagerUtils.getValueFromIdByName(id, "dynamicSchemas");
        if (dynamicSchemaName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dynamicSchemas'.", id)));
        }
        String dynamicSchemaVersionName = ResourceManagerUtils.getValueFromIdByName(id, "versions");
        if (dynamicSchemaVersionName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'versions'.", id)));
        }
        return this.getWithResponse(resourceGroupName, schemaName, dynamicSchemaName, dynamicSchemaVersionName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String schemaName = ResourceManagerUtils.getValueFromIdByName(id, "schemas");
        if (schemaName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'schemas'.", id)));
        }
        String dynamicSchemaName = ResourceManagerUtils.getValueFromIdByName(id, "dynamicSchemas");
        if (dynamicSchemaName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dynamicSchemas'.", id)));
        }
        String dynamicSchemaVersionName = ResourceManagerUtils.getValueFromIdByName(id, "versions");
        if (dynamicSchemaVersionName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'versions'.", id)));
        }
        this.delete(resourceGroupName, schemaName, dynamicSchemaName, dynamicSchemaVersionName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String schemaName = ResourceManagerUtils.getValueFromIdByName(id, "schemas");
        if (schemaName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'schemas'.", id)));
        }
        String dynamicSchemaName = ResourceManagerUtils.getValueFromIdByName(id, "dynamicSchemas");
        if (dynamicSchemaName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dynamicSchemas'.", id)));
        }
        String dynamicSchemaVersionName = ResourceManagerUtils.getValueFromIdByName(id, "versions");
        if (dynamicSchemaVersionName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'versions'.", id)));
        }
        this.delete(resourceGroupName, schemaName, dynamicSchemaName, dynamicSchemaVersionName, context);
    }

    private DynamicSchemaVersionsClient serviceClient() {
        return this.innerClient;
    }

    private WorkloadOrchestrationManager manager() {
        return this.serviceManager;
    }

    @Override
    public DynamicSchemaVersionImpl define(String name) {
        return new DynamicSchemaVersionImpl(name, this.manager());
    }
}

