/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.workloadorchestration.WorkloadOrchestrationManager;
import com.azure.resourcemanager.workloadorchestration.fluent.models.DynamicSchemaInner;
import com.azure.resourcemanager.workloadorchestration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.workloadorchestration.models.DynamicSchema;
import com.azure.resourcemanager.workloadorchestration.models.DynamicSchemaProperties;

public final class DynamicSchemaImpl
implements DynamicSchema,
DynamicSchema.Definition,
DynamicSchema.Update {
    private DynamicSchemaInner innerObject;
    private final WorkloadOrchestrationManager serviceManager;
    private String resourceGroupName;
    private String schemaName;
    private String dynamicSchemaName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public DynamicSchemaProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public String eTag() {
        return this.innerModel().eTag();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public DynamicSchemaInner innerModel() {
        return this.innerObject;
    }

    private WorkloadOrchestrationManager manager() {
        return this.serviceManager;
    }

    @Override
    public DynamicSchemaImpl withExistingSchema(String resourceGroupName, String schemaName) {
        this.resourceGroupName = resourceGroupName;
        this.schemaName = schemaName;
        return this;
    }

    @Override
    public DynamicSchema create() {
        this.innerObject = this.serviceManager.serviceClient().getDynamicSchemas().createOrUpdate(this.resourceGroupName, this.schemaName, this.dynamicSchemaName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public DynamicSchema create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getDynamicSchemas().createOrUpdate(this.resourceGroupName, this.schemaName, this.dynamicSchemaName, this.innerModel(), context);
        return this;
    }

    DynamicSchemaImpl(String name, WorkloadOrchestrationManager serviceManager) {
        this.innerObject = new DynamicSchemaInner();
        this.serviceManager = serviceManager;
        this.dynamicSchemaName = name;
    }

    @Override
    public DynamicSchemaImpl update() {
        return this;
    }

    @Override
    public DynamicSchema apply() {
        this.innerObject = (DynamicSchemaInner)((Object)this.serviceManager.serviceClient().getDynamicSchemas().updateWithResponse(this.resourceGroupName, this.schemaName, this.dynamicSchemaName, this.innerModel(), Context.NONE).getValue());
        return this;
    }

    @Override
    public DynamicSchema apply(Context context) {
        this.innerObject = (DynamicSchemaInner)((Object)this.serviceManager.serviceClient().getDynamicSchemas().updateWithResponse(this.resourceGroupName, this.schemaName, this.dynamicSchemaName, this.innerModel(), context).getValue());
        return this;
    }

    DynamicSchemaImpl(DynamicSchemaInner innerObject, WorkloadOrchestrationManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.schemaName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "schemas");
        this.dynamicSchemaName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "dynamicSchemas");
    }

    @Override
    public DynamicSchema refresh() {
        this.innerObject = (DynamicSchemaInner)((Object)this.serviceManager.serviceClient().getDynamicSchemas().getWithResponse(this.resourceGroupName, this.schemaName, this.dynamicSchemaName, Context.NONE).getValue());
        return this;
    }

    @Override
    public DynamicSchema refresh(Context context) {
        this.innerObject = (DynamicSchemaInner)((Object)this.serviceManager.serviceClient().getDynamicSchemas().getWithResponse(this.resourceGroupName, this.schemaName, this.dynamicSchemaName, context).getValue());
        return this;
    }

    @Override
    public DynamicSchemaImpl withProperties(DynamicSchemaProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }
}

