/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.workloadorchestration.WorkloadOrchestrationManager;
import com.azure.resourcemanager.workloadorchestration.fluent.DiagnosticsClient;
import com.azure.resourcemanager.workloadorchestration.fluent.models.DiagnosticInner;
import com.azure.resourcemanager.workloadorchestration.implementation.DiagnosticImpl;
import com.azure.resourcemanager.workloadorchestration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.workloadorchestration.models.Diagnostic;
import com.azure.resourcemanager.workloadorchestration.models.Diagnostics;

public final class DiagnosticsImpl
implements Diagnostics {
    private static final ClientLogger LOGGER = new ClientLogger(DiagnosticsImpl.class);
    private final DiagnosticsClient innerClient;
    private final WorkloadOrchestrationManager serviceManager;

    public DiagnosticsImpl(DiagnosticsClient innerClient, WorkloadOrchestrationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<Diagnostic> getByResourceGroupWithResponse(String resourceGroupName, String diagnosticName, Context context) {
        Response<DiagnosticInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, diagnosticName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new DiagnosticImpl((DiagnosticInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Diagnostic getByResourceGroup(String resourceGroupName, String diagnosticName) {
        DiagnosticInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, diagnosticName);
        if (inner != null) {
            return new DiagnosticImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String diagnosticName) {
        this.serviceClient().delete(resourceGroupName, diagnosticName);
    }

    @Override
    public void delete(String resourceGroupName, String diagnosticName, Context context) {
        this.serviceClient().delete(resourceGroupName, diagnosticName, context);
    }

    @Override
    public PagedIterable<Diagnostic> listByResourceGroup(String resourceGroupName) {
        PagedIterable<DiagnosticInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DiagnosticImpl((DiagnosticInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Diagnostic> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<DiagnosticInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DiagnosticImpl((DiagnosticInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Diagnostic> list() {
        PagedIterable<DiagnosticInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DiagnosticImpl((DiagnosticInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Diagnostic> list(Context context) {
        PagedIterable<DiagnosticInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new DiagnosticImpl((DiagnosticInner)((Object)inner1), this.manager()));
    }

    @Override
    public Diagnostic getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String diagnosticName = ResourceManagerUtils.getValueFromIdByName(id, "diagnostics");
        if (diagnosticName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'diagnostics'.", id)));
        }
        return (Diagnostic)this.getByResourceGroupWithResponse(resourceGroupName, diagnosticName, Context.NONE).getValue();
    }

    @Override
    public Response<Diagnostic> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String diagnosticName = ResourceManagerUtils.getValueFromIdByName(id, "diagnostics");
        if (diagnosticName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'diagnostics'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, diagnosticName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String diagnosticName = ResourceManagerUtils.getValueFromIdByName(id, "diagnostics");
        if (diagnosticName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'diagnostics'.", id)));
        }
        this.delete(resourceGroupName, diagnosticName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String diagnosticName = ResourceManagerUtils.getValueFromIdByName(id, "diagnostics");
        if (diagnosticName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'diagnostics'.", id)));
        }
        this.delete(resourceGroupName, diagnosticName, context);
    }

    private DiagnosticsClient serviceClient() {
        return this.innerClient;
    }

    private WorkloadOrchestrationManager manager() {
        return this.serviceManager;
    }

    @Override
    public DiagnosticImpl define(String name) {
        return new DiagnosticImpl(name, this.manager());
    }
}

