/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.workloadorchestration.WorkloadOrchestrationManager;
import com.azure.resourcemanager.workloadorchestration.fluent.models.ContextInner;
import com.azure.resourcemanager.workloadorchestration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.workloadorchestration.models.ContextModel;
import com.azure.resourcemanager.workloadorchestration.models.ContextProperties;
import java.util.Collections;
import java.util.Map;

public final class ContextModelImpl
implements ContextModel,
ContextModel.Definition,
ContextModel.Update {
    private ContextInner innerObject;
    private final WorkloadOrchestrationManager serviceManager;
    private String resourceGroupName;
    private String contextName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public ContextProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ContextInner innerModel() {
        return this.innerObject;
    }

    private WorkloadOrchestrationManager manager() {
        return this.serviceManager;
    }

    @Override
    public ContextModelImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public ContextModel create() {
        this.innerObject = this.serviceManager.serviceClient().getContexts().createOrUpdate(this.resourceGroupName, this.contextName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public ContextModel create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getContexts().createOrUpdate(this.resourceGroupName, this.contextName, this.innerModel(), context);
        return this;
    }

    ContextModelImpl(String name, WorkloadOrchestrationManager serviceManager) {
        this.innerObject = new ContextInner();
        this.serviceManager = serviceManager;
        this.contextName = name;
    }

    @Override
    public ContextModelImpl update() {
        return this;
    }

    @Override
    public ContextModel apply() {
        this.innerObject = this.serviceManager.serviceClient().getContexts().update(this.resourceGroupName, this.contextName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public ContextModel apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getContexts().update(this.resourceGroupName, this.contextName, this.innerModel(), context);
        return this;
    }

    ContextModelImpl(ContextInner innerObject, WorkloadOrchestrationManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.contextName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "contexts");
    }

    @Override
    public ContextModel refresh() {
        this.innerObject = (ContextInner)((Object)this.serviceManager.serviceClient().getContexts().getByResourceGroupWithResponse(this.resourceGroupName, this.contextName, Context.NONE).getValue());
        return this;
    }

    @Override
    public ContextModel refresh(Context context) {
        this.innerObject = (ContextInner)((Object)this.serviceManager.serviceClient().getContexts().getByResourceGroupWithResponse(this.resourceGroupName, this.contextName, context).getValue());
        return this;
    }

    @Override
    public ContextModelImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public ContextModelImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public ContextModelImpl withTags(Map<String, String> tags) {
        this.innerModel().withTags((Map)tags);
        return this;
    }

    @Override
    public ContextModelImpl withProperties(ContextProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }
}

