/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.workloadorchestration.WorkloadOrchestrationManager;
import com.azure.resourcemanager.workloadorchestration.fluent.ConfigTemplateVersionsClient;
import com.azure.resourcemanager.workloadorchestration.fluent.models.ConfigTemplateVersionInner;
import com.azure.resourcemanager.workloadorchestration.implementation.ConfigTemplateVersionImpl;
import com.azure.resourcemanager.workloadorchestration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.workloadorchestration.models.ConfigTemplateVersion;
import com.azure.resourcemanager.workloadorchestration.models.ConfigTemplateVersions;

public final class ConfigTemplateVersionsImpl
implements ConfigTemplateVersions {
    private static final ClientLogger LOGGER = new ClientLogger(ConfigTemplateVersionsImpl.class);
    private final ConfigTemplateVersionsClient innerClient;
    private final WorkloadOrchestrationManager serviceManager;

    public ConfigTemplateVersionsImpl(ConfigTemplateVersionsClient innerClient, WorkloadOrchestrationManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<ConfigTemplateVersion> getWithResponse(String resourceGroupName, String configTemplateName, String configTemplateVersionName, Context context) {
        Response<ConfigTemplateVersionInner> inner = this.serviceClient().getWithResponse(resourceGroupName, configTemplateName, configTemplateVersionName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ConfigTemplateVersionImpl((ConfigTemplateVersionInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ConfigTemplateVersion get(String resourceGroupName, String configTemplateName, String configTemplateVersionName) {
        ConfigTemplateVersionInner inner = this.serviceClient().get(resourceGroupName, configTemplateName, configTemplateVersionName);
        if (inner != null) {
            return new ConfigTemplateVersionImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<ConfigTemplateVersion> listByConfigTemplate(String resourceGroupName, String configTemplateName) {
        PagedIterable<ConfigTemplateVersionInner> inner = this.serviceClient().listByConfigTemplate(resourceGroupName, configTemplateName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ConfigTemplateVersionImpl((ConfigTemplateVersionInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ConfigTemplateVersion> listByConfigTemplate(String resourceGroupName, String configTemplateName, Context context) {
        PagedIterable<ConfigTemplateVersionInner> inner = this.serviceClient().listByConfigTemplate(resourceGroupName, configTemplateName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ConfigTemplateVersionImpl((ConfigTemplateVersionInner)((Object)inner1), this.manager()));
    }

    private ConfigTemplateVersionsClient serviceClient() {
        return this.innerClient;
    }

    private WorkloadOrchestrationManager manager() {
        return this.serviceManager;
    }
}

