/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadorchestration.models.ExtendedLocation;
import com.azure.resourcemanager.workloadorchestration.models.TargetProperties;
import java.io.IOException;
import java.util.Map;

public final class TargetInner
extends Resource {
    private TargetProperties properties;
    private String eTag;
    private ExtendedLocation extendedLocation;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    public TargetProperties properties() {
        return this.properties;
    }

    public TargetInner withProperties(TargetProperties properties) {
        this.properties = properties;
        return this;
    }

    public String eTag() {
        return this.eTag;
    }

    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    public TargetInner withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public TargetInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public TargetInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
        if (this.extendedLocation() != null) {
            this.extendedLocation().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        jsonWriter.writeJsonField("extendedLocation", (JsonSerializable)this.extendedLocation);
        return jsonWriter.writeEndObject();
    }

    public static TargetInner fromJson(JsonReader jsonReader) throws IOException {
        return (TargetInner)((Object)jsonReader.readObject(reader -> {
            TargetInner deserializedTargetInner = new TargetInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedTargetInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedTargetInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedTargetInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedTargetInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedTargetInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedTargetInner.properties = TargetProperties.fromJson(reader);
                    continue;
                }
                if ("eTag".equals(fieldName)) {
                    deserializedTargetInner.eTag = reader.getString();
                    continue;
                }
                if ("extendedLocation".equals(fieldName)) {
                    deserializedTargetInner.extendedLocation = ExtendedLocation.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedTargetInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTargetInner;
        }));
    }
}

