/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadorchestration.models.ExtendedLocation;
import com.azure.resourcemanager.workloadorchestration.models.SolutionProperties;
import java.io.IOException;

public final class SolutionInner
extends ProxyResource {
    private SolutionProperties properties;
    private ExtendedLocation extendedLocation;
    private String eTag;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    public SolutionProperties properties() {
        return this.properties;
    }

    public SolutionInner withProperties(SolutionProperties properties) {
        this.properties = properties;
        return this;
    }

    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    public SolutionInner withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    public String eTag() {
        return this.eTag;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
        if (this.extendedLocation() != null) {
            this.extendedLocation().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        jsonWriter.writeJsonField("extendedLocation", (JsonSerializable)this.extendedLocation);
        return jsonWriter.writeEndObject();
    }

    public static SolutionInner fromJson(JsonReader jsonReader) throws IOException {
        return (SolutionInner)((Object)jsonReader.readObject(reader -> {
            SolutionInner deserializedSolutionInner = new SolutionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSolutionInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedSolutionInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSolutionInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedSolutionInner.properties = SolutionProperties.fromJson(reader);
                    continue;
                }
                if ("extendedLocation".equals(fieldName)) {
                    deserializedSolutionInner.extendedLocation = ExtendedLocation.fromJson(reader);
                    continue;
                }
                if ("eTag".equals(fieldName)) {
                    deserializedSolutionInner.eTag = reader.getString();
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedSolutionInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSolutionInner;
        }));
    }
}

