/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadorchestration.models.ExecutionProperties;
import com.azure.resourcemanager.workloadorchestration.models.ExtendedLocation;
import java.io.IOException;

public final class ExecutionInner
extends ProxyResource {
    private ExecutionProperties properties;
    private ExtendedLocation extendedLocation;
    private String eTag;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    public ExecutionProperties properties() {
        return this.properties;
    }

    public ExecutionInner withProperties(ExecutionProperties properties) {
        this.properties = properties;
        return this;
    }

    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    public ExecutionInner withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    public String eTag() {
        return this.eTag;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
        if (this.extendedLocation() != null) {
            this.extendedLocation().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        jsonWriter.writeJsonField("extendedLocation", (JsonSerializable)this.extendedLocation);
        return jsonWriter.writeEndObject();
    }

    public static ExecutionInner fromJson(JsonReader jsonReader) throws IOException {
        return (ExecutionInner)((Object)jsonReader.readObject(reader -> {
            ExecutionInner deserializedExecutionInner = new ExecutionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedExecutionInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedExecutionInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedExecutionInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedExecutionInner.properties = ExecutionProperties.fromJson(reader);
                    continue;
                }
                if ("extendedLocation".equals(fieldName)) {
                    deserializedExecutionInner.extendedLocation = ExtendedLocation.fromJson(reader);
                    continue;
                }
                if ("eTag".equals(fieldName)) {
                    deserializedExecutionInner.eTag = reader.getString();
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedExecutionInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExecutionInner;
        }));
    }
}

