/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadorchestration.models.DiagnosticProperties;
import com.azure.resourcemanager.workloadorchestration.models.ExtendedLocation;
import java.io.IOException;
import java.util.Map;

public final class DiagnosticInner
extends Resource {
    private DiagnosticProperties properties;
    private ExtendedLocation extendedLocation;
    private String eTag;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    public DiagnosticProperties properties() {
        return this.properties;
    }

    public DiagnosticInner withProperties(DiagnosticProperties properties) {
        this.properties = properties;
        return this;
    }

    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    public DiagnosticInner withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    public String eTag() {
        return this.eTag;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public DiagnosticInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public DiagnosticInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
        if (this.extendedLocation() != null) {
            this.extendedLocation().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        jsonWriter.writeJsonField("extendedLocation", (JsonSerializable)this.extendedLocation);
        return jsonWriter.writeEndObject();
    }

    public static DiagnosticInner fromJson(JsonReader jsonReader) throws IOException {
        return (DiagnosticInner)((Object)jsonReader.readObject(reader -> {
            DiagnosticInner deserializedDiagnosticInner = new DiagnosticInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedDiagnosticInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDiagnosticInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDiagnosticInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedDiagnosticInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedDiagnosticInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedDiagnosticInner.properties = DiagnosticProperties.fromJson(reader);
                    continue;
                }
                if ("extendedLocation".equals(fieldName)) {
                    deserializedDiagnosticInner.extendedLocation = ExtendedLocation.fromJson(reader);
                    continue;
                }
                if ("eTag".equals(fieldName)) {
                    deserializedDiagnosticInner.eTag = reader.getString();
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedDiagnosticInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDiagnosticInner;
        }));
    }
}

