/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.workloadorchestration.models.ConfigTemplateProperties;
import java.io.IOException;
import java.util.Map;

public final class ConfigTemplateInner
extends Resource {
    private ConfigTemplateProperties properties;
    private String eTag;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    public ConfigTemplateProperties properties() {
        return this.properties;
    }

    public ConfigTemplateInner withProperties(ConfigTemplateProperties properties) {
        this.properties = properties;
        return this;
    }

    public String eTag() {
        return this.eTag;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public ConfigTemplateInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ConfigTemplateInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static ConfigTemplateInner fromJson(JsonReader jsonReader) throws IOException {
        return (ConfigTemplateInner)((Object)jsonReader.readObject(reader -> {
            ConfigTemplateInner deserializedConfigTemplateInner = new ConfigTemplateInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedConfigTemplateInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedConfigTemplateInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedConfigTemplateInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedConfigTemplateInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedConfigTemplateInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedConfigTemplateInner.properties = ConfigTemplateProperties.fromJson(reader);
                    continue;
                }
                if ("eTag".equals(fieldName)) {
                    deserializedConfigTemplateInner.eTag = reader.getString();
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedConfigTemplateInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConfigTemplateInner;
        }));
    }
}

