/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.workloadorchestration;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.policy.AddDatePolicy;
import com.azure.core.http.policy.AddHeadersFromContextPolicy;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.management.profile.AzureProfile;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.workloadorchestration.fluent.WorkloadOrchestrationManagementClient;
import com.azure.resourcemanager.workloadorchestration.implementation.ConfigTemplateVersionsImpl;
import com.azure.resourcemanager.workloadorchestration.implementation.ConfigTemplatesImpl;
import com.azure.resourcemanager.workloadorchestration.implementation.ContextsImpl;
import com.azure.resourcemanager.workloadorchestration.implementation.DiagnosticsImpl;
import com.azure.resourcemanager.workloadorchestration.implementation.DynamicSchemaVersionsImpl;
import com.azure.resourcemanager.workloadorchestration.implementation.DynamicSchemasImpl;
import com.azure.resourcemanager.workloadorchestration.implementation.ExecutionsImpl;
import com.azure.resourcemanager.workloadorchestration.implementation.InstanceHistoriesImpl;
import com.azure.resourcemanager.workloadorchestration.implementation.InstancesImpl;
import com.azure.resourcemanager.workloadorchestration.implementation.JobsImpl;
import com.azure.resourcemanager.workloadorchestration.implementation.SchemaReferencesImpl;
import com.azure.resourcemanager.workloadorchestration.implementation.SchemaVersionsImpl;
import com.azure.resourcemanager.workloadorchestration.implementation.SchemasImpl;
import com.azure.resourcemanager.workloadorchestration.implementation.SiteReferencesImpl;
import com.azure.resourcemanager.workloadorchestration.implementation.SolutionTemplateVersionsImpl;
import com.azure.resourcemanager.workloadorchestration.implementation.SolutionTemplatesImpl;
import com.azure.resourcemanager.workloadorchestration.implementation.SolutionVersionsImpl;
import com.azure.resourcemanager.workloadorchestration.implementation.SolutionsImpl;
import com.azure.resourcemanager.workloadorchestration.implementation.TargetsImpl;
import com.azure.resourcemanager.workloadorchestration.implementation.WorkflowVersionsImpl;
import com.azure.resourcemanager.workloadorchestration.implementation.WorkflowsImpl;
import com.azure.resourcemanager.workloadorchestration.implementation.WorkloadOrchestrationManagementClientBuilder;
import com.azure.resourcemanager.workloadorchestration.models.ConfigTemplateVersions;
import com.azure.resourcemanager.workloadorchestration.models.ConfigTemplates;
import com.azure.resourcemanager.workloadorchestration.models.Contexts;
import com.azure.resourcemanager.workloadorchestration.models.Diagnostics;
import com.azure.resourcemanager.workloadorchestration.models.DynamicSchemaVersions;
import com.azure.resourcemanager.workloadorchestration.models.DynamicSchemas;
import com.azure.resourcemanager.workloadorchestration.models.Executions;
import com.azure.resourcemanager.workloadorchestration.models.InstanceHistories;
import com.azure.resourcemanager.workloadorchestration.models.Instances;
import com.azure.resourcemanager.workloadorchestration.models.Jobs;
import com.azure.resourcemanager.workloadorchestration.models.SchemaReferences;
import com.azure.resourcemanager.workloadorchestration.models.SchemaVersions;
import com.azure.resourcemanager.workloadorchestration.models.Schemas;
import com.azure.resourcemanager.workloadorchestration.models.SiteReferences;
import com.azure.resourcemanager.workloadorchestration.models.SolutionTemplateVersions;
import com.azure.resourcemanager.workloadorchestration.models.SolutionTemplates;
import com.azure.resourcemanager.workloadorchestration.models.SolutionVersions;
import com.azure.resourcemanager.workloadorchestration.models.Solutions;
import com.azure.resourcemanager.workloadorchestration.models.Targets;
import com.azure.resourcemanager.workloadorchestration.models.WorkflowVersions;
import com.azure.resourcemanager.workloadorchestration.models.Workflows;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class WorkloadOrchestrationManager {
    private DynamicSchemas dynamicSchemas;
    private Schemas schemas;
    private SchemaVersions schemaVersions;
    private SolutionVersions solutionVersions;
    private Jobs jobs;
    private Targets targets;
    private DynamicSchemaVersions dynamicSchemaVersions;
    private SchemaReferences schemaReferences;
    private Solutions solutions;
    private SolutionTemplateVersions solutionTemplateVersions;
    private SolutionTemplates solutionTemplates;
    private Instances instances;
    private InstanceHistories instanceHistories;
    private ConfigTemplates configTemplates;
    private ConfigTemplateVersions configTemplateVersions;
    private Workflows workflows;
    private WorkflowVersions workflowVersions;
    private Executions executions;
    private Diagnostics diagnostics;
    private Contexts contexts;
    private SiteReferences siteReferences;
    private final WorkloadOrchestrationManagementClient clientObject;

    private WorkloadOrchestrationManager(HttpPipeline httpPipeline, AzureProfile profile, Duration defaultPollInterval) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        this.clientObject = new WorkloadOrchestrationManagementClientBuilder().pipeline(httpPipeline).endpoint(profile.getEnvironment().getResourceManagerEndpoint()).subscriptionId(profile.getSubscriptionId()).defaultPollInterval(defaultPollInterval).buildClient();
    }

    public static WorkloadOrchestrationManager authenticate(TokenCredential credential, AzureProfile profile) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return WorkloadOrchestrationManager.configure().authenticate(credential, profile);
    }

    public static WorkloadOrchestrationManager authenticate(HttpPipeline httpPipeline, AzureProfile profile) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return new WorkloadOrchestrationManager(httpPipeline, profile, null);
    }

    public static Configurable configure() {
        return new Configurable();
    }

    public DynamicSchemas dynamicSchemas() {
        if (this.dynamicSchemas == null) {
            this.dynamicSchemas = new DynamicSchemasImpl(this.clientObject.getDynamicSchemas(), this);
        }
        return this.dynamicSchemas;
    }

    public Schemas schemas() {
        if (this.schemas == null) {
            this.schemas = new SchemasImpl(this.clientObject.getSchemas(), this);
        }
        return this.schemas;
    }

    public SchemaVersions schemaVersions() {
        if (this.schemaVersions == null) {
            this.schemaVersions = new SchemaVersionsImpl(this.clientObject.getSchemaVersions(), this);
        }
        return this.schemaVersions;
    }

    public SolutionVersions solutionVersions() {
        if (this.solutionVersions == null) {
            this.solutionVersions = new SolutionVersionsImpl(this.clientObject.getSolutionVersions(), this);
        }
        return this.solutionVersions;
    }

    public Jobs jobs() {
        if (this.jobs == null) {
            this.jobs = new JobsImpl(this.clientObject.getJobs(), this);
        }
        return this.jobs;
    }

    public Targets targets() {
        if (this.targets == null) {
            this.targets = new TargetsImpl(this.clientObject.getTargets(), this);
        }
        return this.targets;
    }

    public DynamicSchemaVersions dynamicSchemaVersions() {
        if (this.dynamicSchemaVersions == null) {
            this.dynamicSchemaVersions = new DynamicSchemaVersionsImpl(this.clientObject.getDynamicSchemaVersions(), this);
        }
        return this.dynamicSchemaVersions;
    }

    public SchemaReferences schemaReferences() {
        if (this.schemaReferences == null) {
            this.schemaReferences = new SchemaReferencesImpl(this.clientObject.getSchemaReferences(), this);
        }
        return this.schemaReferences;
    }

    public Solutions solutions() {
        if (this.solutions == null) {
            this.solutions = new SolutionsImpl(this.clientObject.getSolutions(), this);
        }
        return this.solutions;
    }

    public SolutionTemplateVersions solutionTemplateVersions() {
        if (this.solutionTemplateVersions == null) {
            this.solutionTemplateVersions = new SolutionTemplateVersionsImpl(this.clientObject.getSolutionTemplateVersions(), this);
        }
        return this.solutionTemplateVersions;
    }

    public SolutionTemplates solutionTemplates() {
        if (this.solutionTemplates == null) {
            this.solutionTemplates = new SolutionTemplatesImpl(this.clientObject.getSolutionTemplates(), this);
        }
        return this.solutionTemplates;
    }

    public Instances instances() {
        if (this.instances == null) {
            this.instances = new InstancesImpl(this.clientObject.getInstances(), this);
        }
        return this.instances;
    }

    public InstanceHistories instanceHistories() {
        if (this.instanceHistories == null) {
            this.instanceHistories = new InstanceHistoriesImpl(this.clientObject.getInstanceHistories(), this);
        }
        return this.instanceHistories;
    }

    public ConfigTemplates configTemplates() {
        if (this.configTemplates == null) {
            this.configTemplates = new ConfigTemplatesImpl(this.clientObject.getConfigTemplates(), this);
        }
        return this.configTemplates;
    }

    public ConfigTemplateVersions configTemplateVersions() {
        if (this.configTemplateVersions == null) {
            this.configTemplateVersions = new ConfigTemplateVersionsImpl(this.clientObject.getConfigTemplateVersions(), this);
        }
        return this.configTemplateVersions;
    }

    public Workflows workflows() {
        if (this.workflows == null) {
            this.workflows = new WorkflowsImpl(this.clientObject.getWorkflows(), this);
        }
        return this.workflows;
    }

    public WorkflowVersions workflowVersions() {
        if (this.workflowVersions == null) {
            this.workflowVersions = new WorkflowVersionsImpl(this.clientObject.getWorkflowVersions(), this);
        }
        return this.workflowVersions;
    }

    public Executions executions() {
        if (this.executions == null) {
            this.executions = new ExecutionsImpl(this.clientObject.getExecutions(), this);
        }
        return this.executions;
    }

    public Diagnostics diagnostics() {
        if (this.diagnostics == null) {
            this.diagnostics = new DiagnosticsImpl(this.clientObject.getDiagnostics(), this);
        }
        return this.diagnostics;
    }

    public Contexts contexts() {
        if (this.contexts == null) {
            this.contexts = new ContextsImpl(this.clientObject.getContexts(), this);
        }
        return this.contexts;
    }

    public SiteReferences siteReferences() {
        if (this.siteReferences == null) {
            this.siteReferences = new SiteReferencesImpl(this.clientObject.getSiteReferences(), this);
        }
        return this.siteReferences;
    }

    public WorkloadOrchestrationManagementClient serviceClient() {
        return this.clientObject;
    }

    public static final class Configurable {
        private static final ClientLogger LOGGER = new ClientLogger(Configurable.class);
        private static final String SDK_VERSION = "version";
        private static final Map<String, String> PROPERTIES = CoreUtils.getProperties((String)"azure-resourcemanager-workloadorchestration.properties");
        private HttpClient httpClient;
        private HttpLogOptions httpLogOptions;
        private final List<HttpPipelinePolicy> policies = new ArrayList<HttpPipelinePolicy>();
        private final List<String> scopes = new ArrayList<String>();
        private RetryPolicy retryPolicy;
        private RetryOptions retryOptions;
        private Duration defaultPollInterval;

        private Configurable() {
        }

        public Configurable withHttpClient(HttpClient httpClient) {
            this.httpClient = Objects.requireNonNull(httpClient, "'httpClient' cannot be null.");
            return this;
        }

        public Configurable withLogOptions(HttpLogOptions httpLogOptions) {
            this.httpLogOptions = Objects.requireNonNull(httpLogOptions, "'httpLogOptions' cannot be null.");
            return this;
        }

        public Configurable withPolicy(HttpPipelinePolicy policy) {
            this.policies.add(Objects.requireNonNull(policy, "'policy' cannot be null."));
            return this;
        }

        public Configurable withScope(String scope) {
            this.scopes.add(Objects.requireNonNull(scope, "'scope' cannot be null."));
            return this;
        }

        public Configurable withRetryPolicy(RetryPolicy retryPolicy) {
            this.retryPolicy = Objects.requireNonNull(retryPolicy, "'retryPolicy' cannot be null.");
            return this;
        }

        public Configurable withRetryOptions(RetryOptions retryOptions) {
            this.retryOptions = Objects.requireNonNull(retryOptions, "'retryOptions' cannot be null.");
            return this;
        }

        public Configurable withDefaultPollInterval(Duration defaultPollInterval) {
            this.defaultPollInterval = Objects.requireNonNull(defaultPollInterval, "'defaultPollInterval' cannot be null.");
            if (this.defaultPollInterval.isNegative()) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'defaultPollInterval' cannot be negative"));
            }
            return this;
        }

        public WorkloadOrchestrationManager authenticate(TokenCredential credential, AzureProfile profile) {
            Objects.requireNonNull(credential, "'credential' cannot be null.");
            Objects.requireNonNull(profile, "'profile' cannot be null.");
            String clientVersion = PROPERTIES.getOrDefault(SDK_VERSION, "UnknownVersion");
            StringBuilder userAgentBuilder = new StringBuilder();
            userAgentBuilder.append("azsdk-java").append("-").append("com.azure.resourcemanager.workloadorchestration").append("/").append(clientVersion);
            if (!((Boolean)Configuration.getGlobalConfiguration().get("AZURE_TELEMETRY_DISABLED", (Object)false)).booleanValue()) {
                userAgentBuilder.append(" (").append(Configuration.getGlobalConfiguration().get("java.version")).append("; ").append(Configuration.getGlobalConfiguration().get("os.name")).append("; ").append(Configuration.getGlobalConfiguration().get("os.version")).append("; auto-generated)");
            } else {
                userAgentBuilder.append(" (auto-generated)");
            }
            if (this.scopes.isEmpty()) {
                this.scopes.add(profile.getEnvironment().getManagementEndpoint() + "/.default");
            }
            if (this.retryPolicy == null) {
                this.retryPolicy = this.retryOptions != null ? new RetryPolicy(this.retryOptions) : new RetryPolicy("Retry-After", ChronoUnit.SECONDS);
            }
            ArrayList<Object> policies = new ArrayList<Object>();
            policies.add(new UserAgentPolicy(userAgentBuilder.toString()));
            policies.add(new AddHeadersFromContextPolicy());
            policies.add(new RequestIdPolicy());
            policies.addAll(this.policies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_CALL).collect(Collectors.toList()));
            HttpPolicyProviders.addBeforeRetryPolicies(policies);
            policies.add(this.retryPolicy);
            policies.add(new AddDatePolicy());
            policies.add(new BearerTokenAuthenticationPolicy(credential, this.scopes.toArray(new String[0])));
            policies.addAll(this.policies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_RETRY).collect(Collectors.toList()));
            HttpPolicyProviders.addAfterRetryPolicies(policies);
            policies.add(new HttpLoggingPolicy(this.httpLogOptions));
            HttpPipeline httpPipeline = new HttpPipelineBuilder().httpClient(this.httpClient).policies(policies.toArray(new HttpPipelinePolicy[0])).build();
            return new WorkloadOrchestrationManager(httpPipeline, profile, this.defaultPollInterval);
        }
    }
}

