/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.test.utils;

import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.implementation.util.IdentityUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;

public final class CliRunner {
    private static final ClientLogger LOGGER = new ClientLogger(CliRunner.class);

    private CliRunner() {
    }

    public static String run(String azCommand) throws IOException, InterruptedException {
        String switcher;
        String starter;
        Pattern windowsProcessErrorMessage = Pattern.compile("'azd?' is not recognized");
        Pattern shProcessErrorMessage = Pattern.compile("azd?:.*not found");
        if (IdentityUtil.isWindowsPlatform()) {
            starter = "cmd.exe";
            switcher = "/c";
        } else {
            starter = "/bin/sh";
            switcher = "-c";
        }
        ProcessBuilder builder = new ProcessBuilder(starter, switcher, azCommand);
        builder.redirectInput(ProcessBuilder.Redirect.from(IdentityUtil.NULL_FILE));
        builder.redirectErrorStream(true);
        Process process = builder.start();
        StringBuilder output = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (windowsProcessErrorMessage.matcher(line).find() || shProcessErrorMessage.matcher(line).find()) {
                    throw LOGGER.logExceptionAsError(new RuntimeException("AzureCliCredential authentication unavailable. Azure CLI not installed.To mitigate this issue, please refer to the troubleshooting guidelines here at https://aka.ms/azsdk/java/identity/azclicredential/troubleshoot"));
                }
                output.append(line);
            }
        }
        String processOutput = output.toString();
        boolean finished = process.waitFor(10L, TimeUnit.SECONDS);
        if (!finished) {
            throw LOGGER.logExceptionAsError(new RuntimeException("Process did not complete within the expected time."));
        }
        if (process.exitValue() != 0) {
            if (processOutput.length() > 0) {
                if (processOutput.contains("az login") || processOutput.contains("az account set")) {
                    throw LOGGER.logExceptionAsError(new RuntimeException("AzureCliCredential authentication unavailable. Azure CLI not installed.To mitigate this issue, please refer to the troubleshooting guidelines here at https://aka.ms/azsdk/java/identity/azclicredential/troubleshoot"));
                }
                throw LOGGER.logExceptionAsError((RuntimeException)new ClientAuthenticationException(azCommand + " failed", null));
            }
            throw LOGGER.logExceptionAsError((RuntimeException)new ClientAuthenticationException("Failed to invoke Azure CLI ", null));
        }
        LOGGER.verbose(azCommand + " => A response was received from Azure CLI, deserializing the response.");
        return processOutput;
    }
}

