/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storagecache.fluent.models.ResourceUsageInner;
import java.io.IOException;
import java.util.List;

public final class ResourceUsagesListResult
implements JsonSerializable<ResourceUsagesListResult> {
    private String nextLink;
    private List<ResourceUsageInner> value;

    public String nextLink() {
        return this.nextLink;
    }

    public List<ResourceUsageInner> value() {
        return this.value;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static ResourceUsagesListResult fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceUsagesListResult)jsonReader.readObject(reader -> {
            ResourceUsagesListResult deserializedResourceUsagesListResult = new ResourceUsagesListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("nextLink".equals(fieldName)) {
                    deserializedResourceUsagesListResult.nextLink = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedResourceUsagesListResult.value = value = reader.readArray(reader1 -> ResourceUsageInner.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceUsagesListResult;
        });
    }
}

