/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storagecache.models.CacheUsernameDownloadSettingsCredentials;
import com.azure.resourcemanager.storagecache.models.UsernameDownloadedType;
import com.azure.resourcemanager.storagecache.models.UsernameSource;
import java.io.IOException;

public final class CacheUsernameDownloadSettings
implements JsonSerializable<CacheUsernameDownloadSettings> {
    private Boolean extendedGroups;
    private UsernameSource usernameSource;
    private String groupFileUri;
    private String userFileUri;
    private String ldapServer;
    private String ldapBaseDN;
    private Boolean encryptLdapConnection;
    private Boolean requireValidCertificate;
    private Boolean autoDownloadCertificate;
    private String caCertificateUri;
    private UsernameDownloadedType usernameDownloaded;
    private CacheUsernameDownloadSettingsCredentials credentials;

    public Boolean extendedGroups() {
        return this.extendedGroups;
    }

    public CacheUsernameDownloadSettings withExtendedGroups(Boolean extendedGroups) {
        this.extendedGroups = extendedGroups;
        return this;
    }

    public UsernameSource usernameSource() {
        return this.usernameSource;
    }

    public CacheUsernameDownloadSettings withUsernameSource(UsernameSource usernameSource) {
        this.usernameSource = usernameSource;
        return this;
    }

    public String groupFileUri() {
        return this.groupFileUri;
    }

    public CacheUsernameDownloadSettings withGroupFileUri(String groupFileUri) {
        this.groupFileUri = groupFileUri;
        return this;
    }

    public String userFileUri() {
        return this.userFileUri;
    }

    public CacheUsernameDownloadSettings withUserFileUri(String userFileUri) {
        this.userFileUri = userFileUri;
        return this;
    }

    public String ldapServer() {
        return this.ldapServer;
    }

    public CacheUsernameDownloadSettings withLdapServer(String ldapServer) {
        this.ldapServer = ldapServer;
        return this;
    }

    public String ldapBaseDN() {
        return this.ldapBaseDN;
    }

    public CacheUsernameDownloadSettings withLdapBaseDN(String ldapBaseDN) {
        this.ldapBaseDN = ldapBaseDN;
        return this;
    }

    public Boolean encryptLdapConnection() {
        return this.encryptLdapConnection;
    }

    public CacheUsernameDownloadSettings withEncryptLdapConnection(Boolean encryptLdapConnection) {
        this.encryptLdapConnection = encryptLdapConnection;
        return this;
    }

    public Boolean requireValidCertificate() {
        return this.requireValidCertificate;
    }

    public CacheUsernameDownloadSettings withRequireValidCertificate(Boolean requireValidCertificate) {
        this.requireValidCertificate = requireValidCertificate;
        return this;
    }

    public Boolean autoDownloadCertificate() {
        return this.autoDownloadCertificate;
    }

    public CacheUsernameDownloadSettings withAutoDownloadCertificate(Boolean autoDownloadCertificate) {
        this.autoDownloadCertificate = autoDownloadCertificate;
        return this;
    }

    public String caCertificateUri() {
        return this.caCertificateUri;
    }

    public CacheUsernameDownloadSettings withCaCertificateUri(String caCertificateUri) {
        this.caCertificateUri = caCertificateUri;
        return this;
    }

    public UsernameDownloadedType usernameDownloaded() {
        return this.usernameDownloaded;
    }

    public CacheUsernameDownloadSettingsCredentials credentials() {
        return this.credentials;
    }

    public CacheUsernameDownloadSettings withCredentials(CacheUsernameDownloadSettingsCredentials credentials) {
        this.credentials = credentials;
        return this;
    }

    public void validate() {
        if (this.credentials() != null) {
            this.credentials().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("extendedGroups", this.extendedGroups);
        jsonWriter.writeStringField("usernameSource", this.usernameSource == null ? null : this.usernameSource.toString());
        jsonWriter.writeStringField("groupFileURI", this.groupFileUri);
        jsonWriter.writeStringField("userFileURI", this.userFileUri);
        jsonWriter.writeStringField("ldapServer", this.ldapServer);
        jsonWriter.writeStringField("ldapBaseDN", this.ldapBaseDN);
        jsonWriter.writeBooleanField("encryptLdapConnection", this.encryptLdapConnection);
        jsonWriter.writeBooleanField("requireValidCertificate", this.requireValidCertificate);
        jsonWriter.writeBooleanField("autoDownloadCertificate", this.autoDownloadCertificate);
        jsonWriter.writeStringField("caCertificateURI", this.caCertificateUri);
        jsonWriter.writeJsonField("credentials", (JsonSerializable)this.credentials);
        return jsonWriter.writeEndObject();
    }

    public static CacheUsernameDownloadSettings fromJson(JsonReader jsonReader) throws IOException {
        return (CacheUsernameDownloadSettings)jsonReader.readObject(reader -> {
            CacheUsernameDownloadSettings deserializedCacheUsernameDownloadSettings = new CacheUsernameDownloadSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("extendedGroups".equals(fieldName)) {
                    deserializedCacheUsernameDownloadSettings.extendedGroups = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("usernameSource".equals(fieldName)) {
                    deserializedCacheUsernameDownloadSettings.usernameSource = UsernameSource.fromString(reader.getString());
                    continue;
                }
                if ("groupFileURI".equals(fieldName)) {
                    deserializedCacheUsernameDownloadSettings.groupFileUri = reader.getString();
                    continue;
                }
                if ("userFileURI".equals(fieldName)) {
                    deserializedCacheUsernameDownloadSettings.userFileUri = reader.getString();
                    continue;
                }
                if ("ldapServer".equals(fieldName)) {
                    deserializedCacheUsernameDownloadSettings.ldapServer = reader.getString();
                    continue;
                }
                if ("ldapBaseDN".equals(fieldName)) {
                    deserializedCacheUsernameDownloadSettings.ldapBaseDN = reader.getString();
                    continue;
                }
                if ("encryptLdapConnection".equals(fieldName)) {
                    deserializedCacheUsernameDownloadSettings.encryptLdapConnection = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("requireValidCertificate".equals(fieldName)) {
                    deserializedCacheUsernameDownloadSettings.requireValidCertificate = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("autoDownloadCertificate".equals(fieldName)) {
                    deserializedCacheUsernameDownloadSettings.autoDownloadCertificate = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("caCertificateURI".equals(fieldName)) {
                    deserializedCacheUsernameDownloadSettings.caCertificateUri = reader.getString();
                    continue;
                }
                if ("usernameDownloaded".equals(fieldName)) {
                    deserializedCacheUsernameDownloadSettings.usernameDownloaded = UsernameDownloadedType.fromString(reader.getString());
                    continue;
                }
                if ("credentials".equals(fieldName)) {
                    deserializedCacheUsernameDownloadSettings.credentials = CacheUsernameDownloadSettingsCredentials.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCacheUsernameDownloadSettings;
        });
    }
}

