/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class CacheUpgradeSettings
implements JsonSerializable<CacheUpgradeSettings> {
    private Boolean upgradeScheduleEnabled;
    private OffsetDateTime scheduledTime;

    public Boolean upgradeScheduleEnabled() {
        return this.upgradeScheduleEnabled;
    }

    public CacheUpgradeSettings withUpgradeScheduleEnabled(Boolean upgradeScheduleEnabled) {
        this.upgradeScheduleEnabled = upgradeScheduleEnabled;
        return this;
    }

    public OffsetDateTime scheduledTime() {
        return this.scheduledTime;
    }

    public CacheUpgradeSettings withScheduledTime(OffsetDateTime scheduledTime) {
        this.scheduledTime = scheduledTime;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("upgradeScheduleEnabled", this.upgradeScheduleEnabled);
        jsonWriter.writeStringField("scheduledTime", this.scheduledTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.scheduledTime));
        return jsonWriter.writeEndObject();
    }

    public static CacheUpgradeSettings fromJson(JsonReader jsonReader) throws IOException {
        return (CacheUpgradeSettings)jsonReader.readObject(reader -> {
            CacheUpgradeSettings deserializedCacheUpgradeSettings = new CacheUpgradeSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("upgradeScheduleEnabled".equals(fieldName)) {
                    deserializedCacheUpgradeSettings.upgradeScheduleEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("scheduledTime".equals(fieldName)) {
                    deserializedCacheUpgradeSettings.scheduledTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCacheUpgradeSettings;
        });
    }
}

