/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storagecache.models.AmlFilesystemIdentityType;
import com.azure.resourcemanager.storagecache.models.UserAssignedIdentitiesValue;
import java.io.IOException;
import java.util.Map;

public final class AmlFilesystemIdentity
implements JsonSerializable<AmlFilesystemIdentity> {
    private String principalId;
    private String tenantId;
    private AmlFilesystemIdentityType type;
    private Map<String, UserAssignedIdentitiesValue> userAssignedIdentities;

    public String principalId() {
        return this.principalId;
    }

    public String tenantId() {
        return this.tenantId;
    }

    public AmlFilesystemIdentityType type() {
        return this.type;
    }

    public AmlFilesystemIdentity withType(AmlFilesystemIdentityType type) {
        this.type = type;
        return this;
    }

    public Map<String, UserAssignedIdentitiesValue> userAssignedIdentities() {
        return this.userAssignedIdentities;
    }

    public AmlFilesystemIdentity withUserAssignedIdentities(Map<String, UserAssignedIdentitiesValue> userAssignedIdentities) {
        this.userAssignedIdentities = userAssignedIdentities;
        return this;
    }

    public void validate() {
        if (this.userAssignedIdentities() != null) {
            this.userAssignedIdentities().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeMapField("userAssignedIdentities", this.userAssignedIdentities, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static AmlFilesystemIdentity fromJson(JsonReader jsonReader) throws IOException {
        return (AmlFilesystemIdentity)jsonReader.readObject(reader -> {
            AmlFilesystemIdentity deserializedAmlFilesystemIdentity = new AmlFilesystemIdentity();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("principalId".equals(fieldName)) {
                    deserializedAmlFilesystemIdentity.principalId = reader.getString();
                    continue;
                }
                if ("tenantId".equals(fieldName)) {
                    deserializedAmlFilesystemIdentity.tenantId = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAmlFilesystemIdentity.type = AmlFilesystemIdentityType.fromString(reader.getString());
                    continue;
                }
                if ("userAssignedIdentities".equals(fieldName)) {
                    Map userAssignedIdentities;
                    deserializedAmlFilesystemIdentity.userAssignedIdentities = userAssignedIdentities = reader.readMap(reader1 -> UserAssignedIdentitiesValue.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAmlFilesystemIdentity;
        });
    }
}

