/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.implementation;

import com.azure.core.annotation.ServiceClient;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.management.exception.ManagementError;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.management.polling.PollerFactory;
import com.azure.core.management.polling.SyncPollerFactory;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.AsyncPollResponse;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.resourcemanager.storagecache.fluent.AmlFilesystemsClient;
import com.azure.resourcemanager.storagecache.fluent.AscOperationsClient;
import com.azure.resourcemanager.storagecache.fluent.AscUsagesClient;
import com.azure.resourcemanager.storagecache.fluent.AutoExportJobsClient;
import com.azure.resourcemanager.storagecache.fluent.AutoImportJobsClient;
import com.azure.resourcemanager.storagecache.fluent.CachesClient;
import com.azure.resourcemanager.storagecache.fluent.ImportJobsClient;
import com.azure.resourcemanager.storagecache.fluent.OperationsClient;
import com.azure.resourcemanager.storagecache.fluent.ResourceProvidersClient;
import com.azure.resourcemanager.storagecache.fluent.SkusClient;
import com.azure.resourcemanager.storagecache.fluent.StorageCacheManagementClient;
import com.azure.resourcemanager.storagecache.fluent.StorageTargetOperationsClient;
import com.azure.resourcemanager.storagecache.fluent.StorageTargetsClient;
import com.azure.resourcemanager.storagecache.fluent.UsageModelsClient;
import com.azure.resourcemanager.storagecache.implementation.AmlFilesystemsClientImpl;
import com.azure.resourcemanager.storagecache.implementation.AscOperationsClientImpl;
import com.azure.resourcemanager.storagecache.implementation.AscUsagesClientImpl;
import com.azure.resourcemanager.storagecache.implementation.AutoExportJobsClientImpl;
import com.azure.resourcemanager.storagecache.implementation.AutoImportJobsClientImpl;
import com.azure.resourcemanager.storagecache.implementation.CachesClientImpl;
import com.azure.resourcemanager.storagecache.implementation.ImportJobsClientImpl;
import com.azure.resourcemanager.storagecache.implementation.OperationsClientImpl;
import com.azure.resourcemanager.storagecache.implementation.ResourceProvidersClientImpl;
import com.azure.resourcemanager.storagecache.implementation.SkusClientImpl;
import com.azure.resourcemanager.storagecache.implementation.StorageCacheManagementClientBuilder;
import com.azure.resourcemanager.storagecache.implementation.StorageTargetOperationsClientImpl;
import com.azure.resourcemanager.storagecache.implementation.StorageTargetsClientImpl;
import com.azure.resourcemanager.storagecache.implementation.UsageModelsClientImpl;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=StorageCacheManagementClientBuilder.class)
public final class StorageCacheManagementClientImpl
implements StorageCacheManagementClient {
    private final String subscriptionId;
    private final String endpoint;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final Duration defaultPollInterval;
    private final AmlFilesystemsClient amlFilesystems;
    private final AutoExportJobsClient autoExportJobs;
    private final ImportJobsClient importJobs;
    private final AutoImportJobsClient autoImportJobs;
    private final ResourceProvidersClient resourceProviders;
    private final OperationsClient operations;
    private final SkusClient skus;
    private final UsageModelsClient usageModels;
    private final AscOperationsClient ascOperations;
    private final AscUsagesClient ascUsages;
    private final CachesClient caches;
    private final StorageTargetsClient storageTargets;
    private final StorageTargetOperationsClient storageTargetOperations;
    private static final ClientLogger LOGGER = new ClientLogger(StorageCacheManagementClientImpl.class);

    @Override
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    @Override
    public Duration getDefaultPollInterval() {
        return this.defaultPollInterval;
    }

    @Override
    public AmlFilesystemsClient getAmlFilesystems() {
        return this.amlFilesystems;
    }

    @Override
    public AutoExportJobsClient getAutoExportJobs() {
        return this.autoExportJobs;
    }

    @Override
    public ImportJobsClient getImportJobs() {
        return this.importJobs;
    }

    @Override
    public AutoImportJobsClient getAutoImportJobs() {
        return this.autoImportJobs;
    }

    @Override
    public ResourceProvidersClient getResourceProviders() {
        return this.resourceProviders;
    }

    @Override
    public OperationsClient getOperations() {
        return this.operations;
    }

    @Override
    public SkusClient getSkus() {
        return this.skus;
    }

    @Override
    public UsageModelsClient getUsageModels() {
        return this.usageModels;
    }

    @Override
    public AscOperationsClient getAscOperations() {
        return this.ascOperations;
    }

    @Override
    public AscUsagesClient getAscUsages() {
        return this.ascUsages;
    }

    @Override
    public CachesClient getCaches() {
        return this.caches;
    }

    @Override
    public StorageTargetsClient getStorageTargets() {
        return this.storageTargets;
    }

    @Override
    public StorageTargetOperationsClient getStorageTargetOperations() {
        return this.storageTargetOperations;
    }

    StorageCacheManagementClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, Duration defaultPollInterval, AzureEnvironment environment, String subscriptionId, String endpoint) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.defaultPollInterval = defaultPollInterval;
        this.subscriptionId = subscriptionId;
        this.endpoint = endpoint;
        this.apiVersion = "2025-07-01";
        this.amlFilesystems = new AmlFilesystemsClientImpl(this);
        this.autoExportJobs = new AutoExportJobsClientImpl(this);
        this.importJobs = new ImportJobsClientImpl(this);
        this.autoImportJobs = new AutoImportJobsClientImpl(this);
        this.resourceProviders = new ResourceProvidersClientImpl(this);
        this.operations = new OperationsClientImpl(this);
        this.skus = new SkusClientImpl(this);
        this.usageModels = new UsageModelsClientImpl(this);
        this.ascOperations = new AscOperationsClientImpl(this);
        this.ascUsages = new AscUsagesClientImpl(this);
        this.caches = new CachesClientImpl(this);
        this.storageTargets = new StorageTargetsClientImpl(this);
        this.storageTargetOperations = new StorageTargetOperationsClientImpl(this);
    }

    public Context getContext() {
        return Context.NONE;
    }

    public Context mergeContext(Context context) {
        return CoreUtils.mergeContexts((Context)this.getContext(), (Context)context);
    }

    public <T, U> PollerFlux<PollResult<T>, U> getLroResult(Mono<Response<Flux<ByteBuffer>>> activationResponse, HttpPipeline httpPipeline, Type pollResultType, Type finalResultType, Context context) {
        return PollerFactory.create((SerializerAdapter)this.serializerAdapter, (HttpPipeline)httpPipeline, (Type)pollResultType, (Type)finalResultType, (Duration)this.defaultPollInterval, activationResponse, (Context)context);
    }

    public <T, U> SyncPoller<PollResult<T>, U> getLroResult(Response<BinaryData> activationResponse, Type pollResultType, Type finalResultType, Context context) {
        return SyncPollerFactory.create((SerializerAdapter)this.serializerAdapter, (HttpPipeline)this.httpPipeline, (Type)pollResultType, (Type)finalResultType, (Duration)this.defaultPollInterval, () -> activationResponse, (Context)context);
    }

    public <T, U> Mono<U> getLroFinalResultOrError(AsyncPollResponse<PollResult<T>, U> response) {
        if (response.getStatus() != LongRunningOperationStatus.SUCCESSFULLY_COMPLETED) {
            String errorMessage;
            ManagementError managementError = null;
            HttpResponseImpl errorResponse = null;
            PollResult.Error lroError = ((PollResult)response.getValue()).getError();
            if (lroError != null) {
                errorResponse = new HttpResponseImpl(lroError.getResponseStatusCode(), lroError.getResponseHeaders(), lroError.getResponseBody());
                errorMessage = ((PollResult)response.getValue()).getError().getMessage();
                String errorBody = ((PollResult)response.getValue()).getError().getResponseBody();
                if (errorBody != null) {
                    try {
                        managementError = (ManagementError)this.getSerializerAdapter().deserialize(errorBody, ManagementError.class, SerializerEncoding.JSON);
                        if (managementError.getCode() == null || managementError.getMessage() == null) {
                            managementError = null;
                        }
                    }
                    catch (IOException | RuntimeException ioe) {
                        LOGGER.logThrowableAsWarning((Throwable)ioe);
                    }
                }
            } else {
                errorMessage = "Long running operation failed.";
            }
            if (managementError == null) {
                managementError = new ManagementError(response.getStatus().toString(), errorMessage);
            }
            return Mono.error((Throwable)new ManagementException(errorMessage, (HttpResponse)errorResponse, managementError));
        }
        return response.getFinalResult();
    }

    private static final class HttpResponseImpl
    extends HttpResponse {
        private final int statusCode;
        private final byte[] responseBody;
        private final HttpHeaders httpHeaders;

        HttpResponseImpl(int statusCode, HttpHeaders httpHeaders, String responseBody) {
            super(null);
            this.statusCode = statusCode;
            this.httpHeaders = httpHeaders;
            this.responseBody = responseBody == null ? null : responseBody.getBytes(StandardCharsets.UTF_8);
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getHeaderValue(String s) {
            return this.httpHeaders.getValue(HttpHeaderName.fromString((String)s));
        }

        public HttpHeaders getHeaders() {
            return this.httpHeaders;
        }

        public Flux<ByteBuffer> getBody() {
            return Flux.just((Object)ByteBuffer.wrap(this.responseBody));
        }

        public Mono<byte[]> getBodyAsByteArray() {
            return Mono.just((Object)this.responseBody);
        }

        public Mono<String> getBodyAsString() {
            return Mono.just((Object)new String(this.responseBody, StandardCharsets.UTF_8));
        }

        public Mono<String> getBodyAsString(Charset charset) {
            return Mono.just((Object)new String(this.responseBody, charset));
        }
    }
}

