/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.implementation;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.management.serializer.SerializerFactory;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.storagecache.implementation.StorageCacheManagementClientImpl;
import java.time.Duration;

@ServiceClientBuilder(serviceClients={StorageCacheManagementClientImpl.class})
public final class StorageCacheManagementClientBuilder {
    private String subscriptionId;
    private String endpoint;
    private AzureEnvironment environment;
    private HttpPipeline pipeline;
    private Duration defaultPollInterval;
    private SerializerAdapter serializerAdapter;

    public StorageCacheManagementClientBuilder subscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public StorageCacheManagementClientBuilder endpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public StorageCacheManagementClientBuilder environment(AzureEnvironment environment) {
        this.environment = environment;
        return this;
    }

    public StorageCacheManagementClientBuilder pipeline(HttpPipeline pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    public StorageCacheManagementClientBuilder defaultPollInterval(Duration defaultPollInterval) {
        this.defaultPollInterval = defaultPollInterval;
        return this;
    }

    public StorageCacheManagementClientBuilder serializerAdapter(SerializerAdapter serializerAdapter) {
        this.serializerAdapter = serializerAdapter;
        return this;
    }

    public StorageCacheManagementClientImpl buildClient() {
        String localEndpoint = this.endpoint != null ? this.endpoint : "https://management.azure.com";
        AzureEnvironment localEnvironment = this.environment != null ? this.environment : AzureEnvironment.AZURE;
        HttpPipeline localPipeline = this.pipeline != null ? this.pipeline : new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy()}).build();
        Duration localDefaultPollInterval = this.defaultPollInterval != null ? this.defaultPollInterval : Duration.ofSeconds(30L);
        SerializerAdapter localSerializerAdapter = this.serializerAdapter != null ? this.serializerAdapter : SerializerFactory.createDefaultManagementSerializerAdapter();
        StorageCacheManagementClientImpl client = new StorageCacheManagementClientImpl(localPipeline, localSerializerAdapter, localDefaultPollInterval, localEnvironment, this.subscriptionId, localEndpoint);
        return client;
    }
}

