/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.storagecache.StorageCacheManager;
import com.azure.resourcemanager.storagecache.fluent.SkusClient;
import com.azure.resourcemanager.storagecache.fluent.models.ResourceSkuInner;
import com.azure.resourcemanager.storagecache.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.storagecache.implementation.ResourceSkuImpl;
import com.azure.resourcemanager.storagecache.models.ResourceSku;
import com.azure.resourcemanager.storagecache.models.Skus;

public final class SkusImpl
implements Skus {
    private static final ClientLogger LOGGER = new ClientLogger(SkusImpl.class);
    private final SkusClient innerClient;
    private final StorageCacheManager serviceManager;

    public SkusImpl(SkusClient innerClient, StorageCacheManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<ResourceSku> list() {
        PagedIterable<ResourceSkuInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ResourceSkuImpl((ResourceSkuInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<ResourceSku> list(Context context) {
        PagedIterable<ResourceSkuInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ResourceSkuImpl((ResourceSkuInner)inner1, this.manager()));
    }

    private SkusClient serviceClient() {
        return this.innerClient;
    }

    private StorageCacheManager manager() {
        return this.serviceManager;
    }
}

