/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.storagecache.fluent.ImportJobsClient;
import com.azure.resourcemanager.storagecache.fluent.models.ImportJobInner;
import com.azure.resourcemanager.storagecache.implementation.StorageCacheManagementClientImpl;
import com.azure.resourcemanager.storagecache.models.ImportJobUpdate;
import com.azure.resourcemanager.storagecache.models.ImportJobsListResult;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ImportJobsClientImpl
implements ImportJobsClient {
    private final ImportJobsService service;
    private final StorageCacheManagementClientImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(ImportJobsClientImpl.class);

    ImportJobsClientImpl(StorageCacheManagementClientImpl client) {
        this.service = (ImportJobsService)RestProxy.create(ImportJobsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String amlFilesystemName, String importJobName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (amlFilesystemName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter amlFilesystemName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (importJobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter importJobName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, amlFilesystemName, this.client.getApiVersion(), this.client.getSubscriptionId(), importJobName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String amlFilesystemName, String importJobName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (amlFilesystemName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter amlFilesystemName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (importJobName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter importJobName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteSync(this.client.getEndpoint(), resourceGroupName, amlFilesystemName, this.client.getApiVersion(), this.client.getSubscriptionId(), importJobName, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String amlFilesystemName, String importJobName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (amlFilesystemName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter amlFilesystemName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (importJobName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter importJobName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteSync(this.client.getEndpoint(), resourceGroupName, amlFilesystemName, this.client.getApiVersion(), this.client.getSubscriptionId(), importJobName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String amlFilesystemName, String importJobName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, amlFilesystemName, importJobName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String amlFilesystemName, String importJobName) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, amlFilesystemName, importJobName);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String amlFilesystemName, String importJobName, Context context) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, amlFilesystemName, importJobName, context);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String amlFilesystemName, String importJobName) {
        return this.beginDeleteAsync(resourceGroupName, amlFilesystemName, importJobName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String amlFilesystemName, String importJobName) {
        this.beginDelete(resourceGroupName, amlFilesystemName, importJobName).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String amlFilesystemName, String importJobName, Context context) {
        this.beginDelete(resourceGroupName, amlFilesystemName, importJobName, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ImportJobInner>> getWithResponseAsync(String resourceGroupName, String amlFilesystemName, String importJobName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (amlFilesystemName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter amlFilesystemName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (importJobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter importJobName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, amlFilesystemName, this.client.getApiVersion(), this.client.getSubscriptionId(), importJobName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ImportJobInner> getAsync(String resourceGroupName, String amlFilesystemName, String importJobName) {
        return this.getWithResponseAsync(resourceGroupName, amlFilesystemName, importJobName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ImportJobInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ImportJobInner> getWithResponse(String resourceGroupName, String amlFilesystemName, String importJobName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (amlFilesystemName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter amlFilesystemName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (importJobName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter importJobName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.getSync(this.client.getEndpoint(), resourceGroupName, amlFilesystemName, this.client.getApiVersion(), this.client.getSubscriptionId(), importJobName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ImportJobInner get(String resourceGroupName, String amlFilesystemName, String importJobName) {
        return (ImportJobInner)((Object)this.getWithResponse(resourceGroupName, amlFilesystemName, importJobName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String amlFilesystemName, String importJobName, ImportJobInner importJob) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (amlFilesystemName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter amlFilesystemName is required and cannot be null."));
        }
        if (importJobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter importJobName is required and cannot be null."));
        }
        if (importJob == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter importJob is required and cannot be null."));
        }
        importJob.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), amlFilesystemName, importJobName, importJob, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String resourceGroupName, String amlFilesystemName, String importJobName, ImportJobInner importJob) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (amlFilesystemName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter amlFilesystemName is required and cannot be null."));
        }
        if (importJobName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter importJobName is required and cannot be null."));
        }
        if (importJob == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter importJob is required and cannot be null."));
        }
        importJob.validate();
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), resourceGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), amlFilesystemName, importJobName, importJob, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String resourceGroupName, String amlFilesystemName, String importJobName, ImportJobInner importJob, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (amlFilesystemName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter amlFilesystemName is required and cannot be null."));
        }
        if (importJobName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter importJobName is required and cannot be null."));
        }
        if (importJob == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter importJob is required and cannot be null."));
        }
        importJob.validate();
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), resourceGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), amlFilesystemName, importJobName, importJob, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ImportJobInner>, ImportJobInner> beginCreateOrUpdateAsync(String resourceGroupName, String amlFilesystemName, String importJobName, ImportJobInner importJob) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, amlFilesystemName, importJobName, importJob);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)ImportJobInner.class), (Type)((Object)ImportJobInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ImportJobInner>, ImportJobInner> beginCreateOrUpdate(String resourceGroupName, String amlFilesystemName, String importJobName, ImportJobInner importJob) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, amlFilesystemName, importJobName, importJob);
        return this.client.getLroResult(response, (Type)((Object)ImportJobInner.class), (Type)((Object)ImportJobInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ImportJobInner>, ImportJobInner> beginCreateOrUpdate(String resourceGroupName, String amlFilesystemName, String importJobName, ImportJobInner importJob, Context context) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, amlFilesystemName, importJobName, importJob, context);
        return this.client.getLroResult(response, (Type)((Object)ImportJobInner.class), (Type)((Object)ImportJobInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ImportJobInner> createOrUpdateAsync(String resourceGroupName, String amlFilesystemName, String importJobName, ImportJobInner importJob) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, amlFilesystemName, importJobName, importJob).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ImportJobInner createOrUpdate(String resourceGroupName, String amlFilesystemName, String importJobName, ImportJobInner importJob) {
        return (ImportJobInner)((Object)this.beginCreateOrUpdate(resourceGroupName, amlFilesystemName, importJobName, importJob).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ImportJobInner createOrUpdate(String resourceGroupName, String amlFilesystemName, String importJobName, ImportJobInner importJob, Context context) {
        return (ImportJobInner)((Object)this.beginCreateOrUpdate(resourceGroupName, amlFilesystemName, importJobName, importJob, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String amlFilesystemName, String importJobName, ImportJobUpdate importJob) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (amlFilesystemName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter amlFilesystemName is required and cannot be null."));
        }
        if (importJobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter importJobName is required and cannot be null."));
        }
        if (importJob == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter importJob is required and cannot be null."));
        }
        importJob.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), resourceGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), amlFilesystemName, importJobName, importJob, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> updateWithResponse(String resourceGroupName, String amlFilesystemName, String importJobName, ImportJobUpdate importJob) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (amlFilesystemName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter amlFilesystemName is required and cannot be null."));
        }
        if (importJobName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter importJobName is required and cannot be null."));
        }
        if (importJob == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter importJob is required and cannot be null."));
        }
        importJob.validate();
        String accept = "application/json";
        return this.service.updateSync(this.client.getEndpoint(), resourceGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), amlFilesystemName, importJobName, importJob, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> updateWithResponse(String resourceGroupName, String amlFilesystemName, String importJobName, ImportJobUpdate importJob, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (amlFilesystemName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter amlFilesystemName is required and cannot be null."));
        }
        if (importJobName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter importJobName is required and cannot be null."));
        }
        if (importJob == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter importJob is required and cannot be null."));
        }
        importJob.validate();
        String accept = "application/json";
        return this.service.updateSync(this.client.getEndpoint(), resourceGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), amlFilesystemName, importJobName, importJob, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ImportJobInner>, ImportJobInner> beginUpdateAsync(String resourceGroupName, String amlFilesystemName, String importJobName, ImportJobUpdate importJob) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, amlFilesystemName, importJobName, importJob);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)ImportJobInner.class), (Type)((Object)ImportJobInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ImportJobInner>, ImportJobInner> beginUpdate(String resourceGroupName, String amlFilesystemName, String importJobName, ImportJobUpdate importJob) {
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, amlFilesystemName, importJobName, importJob);
        return this.client.getLroResult(response, (Type)((Object)ImportJobInner.class), (Type)((Object)ImportJobInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ImportJobInner>, ImportJobInner> beginUpdate(String resourceGroupName, String amlFilesystemName, String importJobName, ImportJobUpdate importJob, Context context) {
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, amlFilesystemName, importJobName, importJob, context);
        return this.client.getLroResult(response, (Type)((Object)ImportJobInner.class), (Type)((Object)ImportJobInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ImportJobInner> updateAsync(String resourceGroupName, String amlFilesystemName, String importJobName, ImportJobUpdate importJob) {
        return this.beginUpdateAsync(resourceGroupName, amlFilesystemName, importJobName, importJob).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ImportJobInner update(String resourceGroupName, String amlFilesystemName, String importJobName, ImportJobUpdate importJob) {
        return (ImportJobInner)((Object)this.beginUpdate(resourceGroupName, amlFilesystemName, importJobName, importJob).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ImportJobInner update(String resourceGroupName, String amlFilesystemName, String importJobName, ImportJobUpdate importJob, Context context) {
        return (ImportJobInner)((Object)this.beginUpdate(resourceGroupName, amlFilesystemName, importJobName, importJob, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ImportJobInner>> listByAmlFilesystemSinglePageAsync(String resourceGroupName, String amlFilesystemName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (amlFilesystemName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter amlFilesystemName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByAmlFilesystem(this.client.getEndpoint(), resourceGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), amlFilesystemName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ImportJobsListResult)res.getValue()).value(), ((ImportJobsListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ImportJobInner> listByAmlFilesystemAsync(String resourceGroupName, String amlFilesystemName) {
        return new PagedFlux(() -> this.listByAmlFilesystemSinglePageAsync(resourceGroupName, amlFilesystemName), nextLink -> this.listByAmlFilesystemNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<ImportJobInner> listByAmlFilesystemSinglePage(String resourceGroupName, String amlFilesystemName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (amlFilesystemName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter amlFilesystemName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<ImportJobsListResult> res = this.service.listByAmlFilesystemSync(this.client.getEndpoint(), resourceGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), amlFilesystemName, "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ImportJobsListResult)res.getValue()).value(), ((ImportJobsListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<ImportJobInner> listByAmlFilesystemSinglePage(String resourceGroupName, String amlFilesystemName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (amlFilesystemName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter amlFilesystemName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<ImportJobsListResult> res = this.service.listByAmlFilesystemSync(this.client.getEndpoint(), resourceGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), amlFilesystemName, "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ImportJobsListResult)res.getValue()).value(), ((ImportJobsListResult)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ImportJobInner> listByAmlFilesystem(String resourceGroupName, String amlFilesystemName) {
        return new PagedIterable(() -> this.listByAmlFilesystemSinglePage(resourceGroupName, amlFilesystemName), nextLink -> this.listByAmlFilesystemNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ImportJobInner> listByAmlFilesystem(String resourceGroupName, String amlFilesystemName, Context context) {
        return new PagedIterable(() -> this.listByAmlFilesystemSinglePage(resourceGroupName, amlFilesystemName, context), nextLink -> this.listByAmlFilesystemNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ImportJobInner>> listByAmlFilesystemNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByAmlFilesystemNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ImportJobsListResult)res.getValue()).value(), ((ImportJobsListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<ImportJobInner> listByAmlFilesystemNextSinglePage(String nextLink) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<ImportJobsListResult> res = this.service.listByAmlFilesystemNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ImportJobsListResult)res.getValue()).value(), ((ImportJobsListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<ImportJobInner> listByAmlFilesystemNextSinglePage(String nextLink, Context context) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<ImportJobsListResult> res = this.service.listByAmlFilesystemNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ImportJobsListResult)res.getValue()).value(), ((ImportJobsListResult)res.getValue()).nextLink(), null);
    }

    @Host(value="{$host}")
    @ServiceInterface(name="StorageCacheManagementClientImportJobs")
    public static interface ImportJobsService {
        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageCache/amlFilesystems/{amlFilesystemName}/importJobs/{importJobName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="amlFilesystemName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @PathParam(value="importJobName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageCache/amlFilesystems/{amlFilesystemName}/importJobs/{importJobName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> deleteSync(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="amlFilesystemName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @PathParam(value="importJobName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageCache/amlFilesystems/{amlFilesystemName}/importJobs/{importJobName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ImportJobInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="amlFilesystemName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @PathParam(value="importJobName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageCache/amlFilesystems/{amlFilesystemName}/importJobs/{importJobName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<ImportJobInner> getSync(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="amlFilesystemName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @PathParam(value="importJobName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageCache/amlFilesystems/{amlFilesystemName}/importJobs/{importJobName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="amlFilesystemName") String var5, @PathParam(value="importJobName") String var6, @BodyParam(value="application/json") ImportJobInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageCache/amlFilesystems/{amlFilesystemName}/importJobs/{importJobName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> createOrUpdateSync(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="amlFilesystemName") String var5, @PathParam(value="importJobName") String var6, @BodyParam(value="application/json") ImportJobInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageCache/amlFilesystems/{amlFilesystemName}/importJobs/{importJobName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="amlFilesystemName") String var5, @PathParam(value="importJobName") String var6, @BodyParam(value="application/json") ImportJobUpdate var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageCache/amlFilesystems/{amlFilesystemName}/importJobs/{importJobName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> updateSync(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="amlFilesystemName") String var5, @PathParam(value="importJobName") String var6, @BodyParam(value="application/json") ImportJobUpdate var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageCache/amlFilesystems/{amlFilesystemName}/importJobs")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ImportJobsListResult>> listByAmlFilesystem(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="amlFilesystemName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageCache/amlFilesystems/{amlFilesystemName}/importJobs")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<ImportJobsListResult> listByAmlFilesystemSync(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="amlFilesystemName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ImportJobsListResult>> listByAmlFilesystemNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<ImportJobsListResult> listByAmlFilesystemNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

