/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.storagecache.fluent.AutoImportJobsClient;
import com.azure.resourcemanager.storagecache.fluent.models.AutoImportJobInner;
import com.azure.resourcemanager.storagecache.implementation.StorageCacheManagementClientImpl;
import com.azure.resourcemanager.storagecache.models.AutoImportJobUpdate;
import com.azure.resourcemanager.storagecache.models.AutoImportJobsListResult;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class AutoImportJobsClientImpl
implements AutoImportJobsClient {
    private final AutoImportJobsService service;
    private final StorageCacheManagementClientImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(AutoImportJobsClientImpl.class);

    AutoImportJobsClientImpl(StorageCacheManagementClientImpl client) {
        this.service = (AutoImportJobsService)RestProxy.create(AutoImportJobsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String amlFilesystemName, String autoImportJobName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (amlFilesystemName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter amlFilesystemName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (autoImportJobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter autoImportJobName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, amlFilesystemName, this.client.getApiVersion(), this.client.getSubscriptionId(), autoImportJobName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String amlFilesystemName, String autoImportJobName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (amlFilesystemName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter amlFilesystemName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (autoImportJobName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter autoImportJobName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteSync(this.client.getEndpoint(), resourceGroupName, amlFilesystemName, this.client.getApiVersion(), this.client.getSubscriptionId(), autoImportJobName, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String amlFilesystemName, String autoImportJobName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (amlFilesystemName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter amlFilesystemName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (autoImportJobName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter autoImportJobName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteSync(this.client.getEndpoint(), resourceGroupName, amlFilesystemName, this.client.getApiVersion(), this.client.getSubscriptionId(), autoImportJobName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String amlFilesystemName, String autoImportJobName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, amlFilesystemName, autoImportJobName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String amlFilesystemName, String autoImportJobName) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, amlFilesystemName, autoImportJobName);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String amlFilesystemName, String autoImportJobName, Context context) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, amlFilesystemName, autoImportJobName, context);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String amlFilesystemName, String autoImportJobName) {
        return this.beginDeleteAsync(resourceGroupName, amlFilesystemName, autoImportJobName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String amlFilesystemName, String autoImportJobName) {
        this.beginDelete(resourceGroupName, amlFilesystemName, autoImportJobName).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String amlFilesystemName, String autoImportJobName, Context context) {
        this.beginDelete(resourceGroupName, amlFilesystemName, autoImportJobName, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AutoImportJobInner>> getWithResponseAsync(String resourceGroupName, String amlFilesystemName, String autoImportJobName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (amlFilesystemName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter amlFilesystemName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (autoImportJobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter autoImportJobName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, amlFilesystemName, this.client.getApiVersion(), this.client.getSubscriptionId(), autoImportJobName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AutoImportJobInner> getAsync(String resourceGroupName, String amlFilesystemName, String autoImportJobName) {
        return this.getWithResponseAsync(resourceGroupName, amlFilesystemName, autoImportJobName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((AutoImportJobInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AutoImportJobInner> getWithResponse(String resourceGroupName, String amlFilesystemName, String autoImportJobName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (amlFilesystemName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter amlFilesystemName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (autoImportJobName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter autoImportJobName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.getSync(this.client.getEndpoint(), resourceGroupName, amlFilesystemName, this.client.getApiVersion(), this.client.getSubscriptionId(), autoImportJobName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AutoImportJobInner get(String resourceGroupName, String amlFilesystemName, String autoImportJobName) {
        return (AutoImportJobInner)((Object)this.getWithResponse(resourceGroupName, amlFilesystemName, autoImportJobName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String amlFilesystemName, String autoImportJobName, AutoImportJobInner autoImportJob) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (amlFilesystemName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter amlFilesystemName is required and cannot be null."));
        }
        if (autoImportJobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter autoImportJobName is required and cannot be null."));
        }
        if (autoImportJob == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter autoImportJob is required and cannot be null."));
        }
        autoImportJob.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), amlFilesystemName, autoImportJobName, autoImportJob, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String resourceGroupName, String amlFilesystemName, String autoImportJobName, AutoImportJobInner autoImportJob) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (amlFilesystemName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter amlFilesystemName is required and cannot be null."));
        }
        if (autoImportJobName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter autoImportJobName is required and cannot be null."));
        }
        if (autoImportJob == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter autoImportJob is required and cannot be null."));
        }
        autoImportJob.validate();
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), resourceGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), amlFilesystemName, autoImportJobName, autoImportJob, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String resourceGroupName, String amlFilesystemName, String autoImportJobName, AutoImportJobInner autoImportJob, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (amlFilesystemName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter amlFilesystemName is required and cannot be null."));
        }
        if (autoImportJobName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter autoImportJobName is required and cannot be null."));
        }
        if (autoImportJob == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter autoImportJob is required and cannot be null."));
        }
        autoImportJob.validate();
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), resourceGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), amlFilesystemName, autoImportJobName, autoImportJob, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<AutoImportJobInner>, AutoImportJobInner> beginCreateOrUpdateAsync(String resourceGroupName, String amlFilesystemName, String autoImportJobName, AutoImportJobInner autoImportJob) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, amlFilesystemName, autoImportJobName, autoImportJob);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)AutoImportJobInner.class), (Type)((Object)AutoImportJobInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<AutoImportJobInner>, AutoImportJobInner> beginCreateOrUpdate(String resourceGroupName, String amlFilesystemName, String autoImportJobName, AutoImportJobInner autoImportJob) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, amlFilesystemName, autoImportJobName, autoImportJob);
        return this.client.getLroResult(response, (Type)((Object)AutoImportJobInner.class), (Type)((Object)AutoImportJobInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<AutoImportJobInner>, AutoImportJobInner> beginCreateOrUpdate(String resourceGroupName, String amlFilesystemName, String autoImportJobName, AutoImportJobInner autoImportJob, Context context) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, amlFilesystemName, autoImportJobName, autoImportJob, context);
        return this.client.getLroResult(response, (Type)((Object)AutoImportJobInner.class), (Type)((Object)AutoImportJobInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AutoImportJobInner> createOrUpdateAsync(String resourceGroupName, String amlFilesystemName, String autoImportJobName, AutoImportJobInner autoImportJob) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, amlFilesystemName, autoImportJobName, autoImportJob).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AutoImportJobInner createOrUpdate(String resourceGroupName, String amlFilesystemName, String autoImportJobName, AutoImportJobInner autoImportJob) {
        return (AutoImportJobInner)((Object)this.beginCreateOrUpdate(resourceGroupName, amlFilesystemName, autoImportJobName, autoImportJob).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AutoImportJobInner createOrUpdate(String resourceGroupName, String amlFilesystemName, String autoImportJobName, AutoImportJobInner autoImportJob, Context context) {
        return (AutoImportJobInner)((Object)this.beginCreateOrUpdate(resourceGroupName, amlFilesystemName, autoImportJobName, autoImportJob, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String amlFilesystemName, String autoImportJobName, AutoImportJobUpdate autoImportJob) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (amlFilesystemName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter amlFilesystemName is required and cannot be null."));
        }
        if (autoImportJobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter autoImportJobName is required and cannot be null."));
        }
        if (autoImportJob == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter autoImportJob is required and cannot be null."));
        }
        autoImportJob.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), resourceGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), amlFilesystemName, autoImportJobName, autoImportJob, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> updateWithResponse(String resourceGroupName, String amlFilesystemName, String autoImportJobName, AutoImportJobUpdate autoImportJob) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (amlFilesystemName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter amlFilesystemName is required and cannot be null."));
        }
        if (autoImportJobName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter autoImportJobName is required and cannot be null."));
        }
        if (autoImportJob == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter autoImportJob is required and cannot be null."));
        }
        autoImportJob.validate();
        String accept = "application/json";
        return this.service.updateSync(this.client.getEndpoint(), resourceGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), amlFilesystemName, autoImportJobName, autoImportJob, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> updateWithResponse(String resourceGroupName, String amlFilesystemName, String autoImportJobName, AutoImportJobUpdate autoImportJob, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (amlFilesystemName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter amlFilesystemName is required and cannot be null."));
        }
        if (autoImportJobName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter autoImportJobName is required and cannot be null."));
        }
        if (autoImportJob == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter autoImportJob is required and cannot be null."));
        }
        autoImportJob.validate();
        String accept = "application/json";
        return this.service.updateSync(this.client.getEndpoint(), resourceGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), amlFilesystemName, autoImportJobName, autoImportJob, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<AutoImportJobInner>, AutoImportJobInner> beginUpdateAsync(String resourceGroupName, String amlFilesystemName, String autoImportJobName, AutoImportJobUpdate autoImportJob) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, amlFilesystemName, autoImportJobName, autoImportJob);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)AutoImportJobInner.class), (Type)((Object)AutoImportJobInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<AutoImportJobInner>, AutoImportJobInner> beginUpdate(String resourceGroupName, String amlFilesystemName, String autoImportJobName, AutoImportJobUpdate autoImportJob) {
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, amlFilesystemName, autoImportJobName, autoImportJob);
        return this.client.getLroResult(response, (Type)((Object)AutoImportJobInner.class), (Type)((Object)AutoImportJobInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<AutoImportJobInner>, AutoImportJobInner> beginUpdate(String resourceGroupName, String amlFilesystemName, String autoImportJobName, AutoImportJobUpdate autoImportJob, Context context) {
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, amlFilesystemName, autoImportJobName, autoImportJob, context);
        return this.client.getLroResult(response, (Type)((Object)AutoImportJobInner.class), (Type)((Object)AutoImportJobInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AutoImportJobInner> updateAsync(String resourceGroupName, String amlFilesystemName, String autoImportJobName, AutoImportJobUpdate autoImportJob) {
        return this.beginUpdateAsync(resourceGroupName, amlFilesystemName, autoImportJobName, autoImportJob).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AutoImportJobInner update(String resourceGroupName, String amlFilesystemName, String autoImportJobName, AutoImportJobUpdate autoImportJob) {
        return (AutoImportJobInner)((Object)this.beginUpdate(resourceGroupName, amlFilesystemName, autoImportJobName, autoImportJob).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AutoImportJobInner update(String resourceGroupName, String amlFilesystemName, String autoImportJobName, AutoImportJobUpdate autoImportJob, Context context) {
        return (AutoImportJobInner)((Object)this.beginUpdate(resourceGroupName, amlFilesystemName, autoImportJobName, autoImportJob, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AutoImportJobInner>> listByAmlFilesystemSinglePageAsync(String resourceGroupName, String amlFilesystemName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (amlFilesystemName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter amlFilesystemName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByAmlFilesystem(this.client.getEndpoint(), resourceGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), amlFilesystemName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AutoImportJobsListResult)res.getValue()).value(), ((AutoImportJobsListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<AutoImportJobInner> listByAmlFilesystemAsync(String resourceGroupName, String amlFilesystemName) {
        return new PagedFlux(() -> this.listByAmlFilesystemSinglePageAsync(resourceGroupName, amlFilesystemName), nextLink -> this.listByAmlFilesystemNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<AutoImportJobInner> listByAmlFilesystemSinglePage(String resourceGroupName, String amlFilesystemName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (amlFilesystemName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter amlFilesystemName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<AutoImportJobsListResult> res = this.service.listByAmlFilesystemSync(this.client.getEndpoint(), resourceGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), amlFilesystemName, "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AutoImportJobsListResult)res.getValue()).value(), ((AutoImportJobsListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<AutoImportJobInner> listByAmlFilesystemSinglePage(String resourceGroupName, String amlFilesystemName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (amlFilesystemName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter amlFilesystemName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<AutoImportJobsListResult> res = this.service.listByAmlFilesystemSync(this.client.getEndpoint(), resourceGroupName, this.client.getApiVersion(), this.client.getSubscriptionId(), amlFilesystemName, "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AutoImportJobsListResult)res.getValue()).value(), ((AutoImportJobsListResult)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AutoImportJobInner> listByAmlFilesystem(String resourceGroupName, String amlFilesystemName) {
        return new PagedIterable(() -> this.listByAmlFilesystemSinglePage(resourceGroupName, amlFilesystemName), nextLink -> this.listByAmlFilesystemNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AutoImportJobInner> listByAmlFilesystem(String resourceGroupName, String amlFilesystemName, Context context) {
        return new PagedIterable(() -> this.listByAmlFilesystemSinglePage(resourceGroupName, amlFilesystemName, context), nextLink -> this.listByAmlFilesystemNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AutoImportJobInner>> listByAmlFilesystemNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByAmlFilesystemNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AutoImportJobsListResult)res.getValue()).value(), ((AutoImportJobsListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<AutoImportJobInner> listByAmlFilesystemNextSinglePage(String nextLink) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<AutoImportJobsListResult> res = this.service.listByAmlFilesystemNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AutoImportJobsListResult)res.getValue()).value(), ((AutoImportJobsListResult)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<AutoImportJobInner> listByAmlFilesystemNextSinglePage(String nextLink, Context context) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<AutoImportJobsListResult> res = this.service.listByAmlFilesystemNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AutoImportJobsListResult)res.getValue()).value(), ((AutoImportJobsListResult)res.getValue()).nextLink(), null);
    }

    @Host(value="{$host}")
    @ServiceInterface(name="StorageCacheManagementClientAutoImportJobs")
    public static interface AutoImportJobsService {
        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageCache/amlFilesystems/{amlFilesystemName}/autoImportJobs/{autoImportJobName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="amlFilesystemName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @PathParam(value="autoImportJobName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageCache/amlFilesystems/{amlFilesystemName}/autoImportJobs/{autoImportJobName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> deleteSync(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="amlFilesystemName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @PathParam(value="autoImportJobName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageCache/amlFilesystems/{amlFilesystemName}/autoImportJobs/{autoImportJobName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AutoImportJobInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="amlFilesystemName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @PathParam(value="autoImportJobName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageCache/amlFilesystems/{amlFilesystemName}/autoImportJobs/{autoImportJobName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<AutoImportJobInner> getSync(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="amlFilesystemName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @PathParam(value="autoImportJobName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageCache/amlFilesystems/{amlFilesystemName}/autoImportJobs/{autoImportJobName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="amlFilesystemName") String var5, @PathParam(value="autoImportJobName") String var6, @BodyParam(value="application/json") AutoImportJobInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageCache/amlFilesystems/{amlFilesystemName}/autoImportJobs/{autoImportJobName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> createOrUpdateSync(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="amlFilesystemName") String var5, @PathParam(value="autoImportJobName") String var6, @BodyParam(value="application/json") AutoImportJobInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageCache/amlFilesystems/{amlFilesystemName}/autoImportJobs/{autoImportJobName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="amlFilesystemName") String var5, @PathParam(value="autoImportJobName") String var6, @BodyParam(value="application/json") AutoImportJobUpdate var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageCache/amlFilesystems/{amlFilesystemName}/autoImportJobs/{autoImportJobName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> updateSync(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="amlFilesystemName") String var5, @PathParam(value="autoImportJobName") String var6, @BodyParam(value="application/json") AutoImportJobUpdate var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageCache/amlFilesystems/{amlFilesystemName}/autoImportJobs")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AutoImportJobsListResult>> listByAmlFilesystem(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="amlFilesystemName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageCache/amlFilesystems/{amlFilesystemName}/autoImportJobs")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<AutoImportJobsListResult> listByAmlFilesystemSync(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @PathParam(value="amlFilesystemName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AutoImportJobsListResult>> listByAmlFilesystemNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<AutoImportJobsListResult> listByAmlFilesystemNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

