/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.storagecache.StorageCacheManager;
import com.azure.resourcemanager.storagecache.fluent.models.AutoExportJobInner;
import com.azure.resourcemanager.storagecache.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.storagecache.models.AutoExportJob;
import com.azure.resourcemanager.storagecache.models.AutoExportJobAdminStatus;
import com.azure.resourcemanager.storagecache.models.AutoExportJobProvisioningStateType;
import com.azure.resourcemanager.storagecache.models.AutoExportJobUpdate;
import com.azure.resourcemanager.storagecache.models.AutoExportStatusType;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class AutoExportJobImpl
implements AutoExportJob,
AutoExportJob.Definition,
AutoExportJob.Update {
    private AutoExportJobInner innerObject;
    private final StorageCacheManager serviceManager;
    private String resourceGroupName;
    private String amlFilesystemName;
    private String autoExportJobName;
    private AutoExportJobUpdate updateAutoExportJob;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public AutoExportJobProvisioningStateType provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public AutoExportJobAdminStatus adminStatus() {
        return this.innerModel().adminStatus();
    }

    @Override
    public List<String> autoExportPrefixes() {
        List<String> inner = this.innerModel().autoExportPrefixes();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public AutoExportStatusType state() {
        return this.innerModel().state();
    }

    @Override
    public String statusCode() {
        return this.innerModel().statusCode();
    }

    @Override
    public String statusMessage() {
        return this.innerModel().statusMessage();
    }

    @Override
    public Long totalFilesExported() {
        return this.innerModel().totalFilesExported();
    }

    @Override
    public Long totalMiBExported() {
        return this.innerModel().totalMiBExported();
    }

    @Override
    public Long totalFilesFailed() {
        return this.innerModel().totalFilesFailed();
    }

    @Override
    public Integer exportIterationCount() {
        return this.innerModel().exportIterationCount();
    }

    @Override
    public OffsetDateTime lastSuccessfulIterationCompletionTimeUtc() {
        return this.innerModel().lastSuccessfulIterationCompletionTimeUtc();
    }

    @Override
    public Long currentIterationFilesDiscovered() {
        return this.innerModel().currentIterationFilesDiscovered();
    }

    @Override
    public Long currentIterationMiBDiscovered() {
        return this.innerModel().currentIterationMiBDiscovered();
    }

    @Override
    public Long currentIterationFilesExported() {
        return this.innerModel().currentIterationFilesExported();
    }

    @Override
    public Long currentIterationMiBExported() {
        return this.innerModel().currentIterationMiBExported();
    }

    @Override
    public Long currentIterationFilesFailed() {
        return this.innerModel().currentIterationFilesFailed();
    }

    @Override
    public OffsetDateTime lastStartedTimeUtc() {
        return this.innerModel().lastStartedTimeUtc();
    }

    @Override
    public OffsetDateTime lastCompletionTimeUtc() {
        return this.innerModel().lastCompletionTimeUtc();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public AutoExportJobInner innerModel() {
        return this.innerObject;
    }

    private StorageCacheManager manager() {
        return this.serviceManager;
    }

    @Override
    public AutoExportJobImpl withExistingAmlFilesystem(String resourceGroupName, String amlFilesystemName) {
        this.resourceGroupName = resourceGroupName;
        this.amlFilesystemName = amlFilesystemName;
        return this;
    }

    @Override
    public AutoExportJob create() {
        this.innerObject = this.serviceManager.serviceClient().getAutoExportJobs().createOrUpdate(this.resourceGroupName, this.amlFilesystemName, this.autoExportJobName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public AutoExportJob create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getAutoExportJobs().createOrUpdate(this.resourceGroupName, this.amlFilesystemName, this.autoExportJobName, this.innerModel(), context);
        return this;
    }

    AutoExportJobImpl(String name, StorageCacheManager serviceManager) {
        this.innerObject = new AutoExportJobInner();
        this.serviceManager = serviceManager;
        this.autoExportJobName = name;
    }

    @Override
    public AutoExportJobImpl update() {
        this.updateAutoExportJob = new AutoExportJobUpdate();
        return this;
    }

    @Override
    public AutoExportJob apply() {
        this.innerObject = this.serviceManager.serviceClient().getAutoExportJobs().update(this.resourceGroupName, this.amlFilesystemName, this.autoExportJobName, this.updateAutoExportJob, Context.NONE);
        return this;
    }

    @Override
    public AutoExportJob apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getAutoExportJobs().update(this.resourceGroupName, this.amlFilesystemName, this.autoExportJobName, this.updateAutoExportJob, context);
        return this;
    }

    AutoExportJobImpl(AutoExportJobInner innerObject, StorageCacheManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.amlFilesystemName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "amlFilesystems");
        this.autoExportJobName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "autoExportJobs");
    }

    @Override
    public AutoExportJob refresh() {
        this.innerObject = (AutoExportJobInner)((Object)this.serviceManager.serviceClient().getAutoExportJobs().getWithResponse(this.resourceGroupName, this.amlFilesystemName, this.autoExportJobName, Context.NONE).getValue());
        return this;
    }

    @Override
    public AutoExportJob refresh(Context context) {
        this.innerObject = (AutoExportJobInner)((Object)this.serviceManager.serviceClient().getAutoExportJobs().getWithResponse(this.resourceGroupName, this.amlFilesystemName, this.autoExportJobName, context).getValue());
        return this;
    }

    @Override
    public AutoExportJobImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public AutoExportJobImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public AutoExportJobImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateAutoExportJob.withTags(tags);
        return this;
    }

    @Override
    public AutoExportJobImpl withAdminStatus(AutoExportJobAdminStatus adminStatus) {
        if (this.isInCreateMode()) {
            this.innerModel().withAdminStatus(adminStatus);
            return this;
        }
        this.updateAutoExportJob.withAdminStatus(adminStatus);
        return this;
    }

    @Override
    public AutoExportJobImpl withAutoExportPrefixes(List<String> autoExportPrefixes) {
        this.innerModel().withAutoExportPrefixes(autoExportPrefixes);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

