/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.storagecache.StorageCacheManager;
import com.azure.resourcemanager.storagecache.fluent.AscOperationsClient;
import com.azure.resourcemanager.storagecache.fluent.models.AscOperationInner;
import com.azure.resourcemanager.storagecache.implementation.AscOperationImpl;
import com.azure.resourcemanager.storagecache.models.AscOperation;
import com.azure.resourcemanager.storagecache.models.AscOperations;

public final class AscOperationsImpl
implements AscOperations {
    private static final ClientLogger LOGGER = new ClientLogger(AscOperationsImpl.class);
    private final AscOperationsClient innerClient;
    private final StorageCacheManager serviceManager;

    public AscOperationsImpl(AscOperationsClient innerClient, StorageCacheManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<AscOperation> getWithResponse(String location, String operationId, Context context) {
        Response<AscOperationInner> inner = this.serviceClient().getWithResponse(location, operationId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new AscOperationImpl((AscOperationInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public AscOperation get(String location, String operationId) {
        AscOperationInner inner = this.serviceClient().get(location, operationId);
        if (inner != null) {
            return new AscOperationImpl(inner, this.manager());
        }
        return null;
    }

    private AscOperationsClient serviceClient() {
        return this.innerClient;
    }

    private StorageCacheManager manager() {
        return this.serviceManager;
    }
}

