/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.storagecache.StorageCacheManager;
import com.azure.resourcemanager.storagecache.fluent.models.AmlFilesystemInner;
import com.azure.resourcemanager.storagecache.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.storagecache.models.AmlFilesystem;
import com.azure.resourcemanager.storagecache.models.AmlFilesystemArchiveInfo;
import com.azure.resourcemanager.storagecache.models.AmlFilesystemClientInfo;
import com.azure.resourcemanager.storagecache.models.AmlFilesystemEncryptionSettings;
import com.azure.resourcemanager.storagecache.models.AmlFilesystemHealth;
import com.azure.resourcemanager.storagecache.models.AmlFilesystemIdentity;
import com.azure.resourcemanager.storagecache.models.AmlFilesystemPropertiesHsm;
import com.azure.resourcemanager.storagecache.models.AmlFilesystemPropertiesMaintenanceWindow;
import com.azure.resourcemanager.storagecache.models.AmlFilesystemProvisioningStateType;
import com.azure.resourcemanager.storagecache.models.AmlFilesystemRootSquashSettings;
import com.azure.resourcemanager.storagecache.models.AmlFilesystemUpdate;
import com.azure.resourcemanager.storagecache.models.AmlFilesystemUpdatePropertiesMaintenanceWindow;
import com.azure.resourcemanager.storagecache.models.SkuName;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class AmlFilesystemImpl
implements AmlFilesystem,
AmlFilesystem.Definition,
AmlFilesystem.Update {
    private AmlFilesystemInner innerObject;
    private final StorageCacheManager serviceManager;
    private String resourceGroupName;
    private String amlFilesystemName;
    private AmlFilesystemUpdate updateAmlFilesystem;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public AmlFilesystemIdentity identity() {
        return this.innerModel().identity();
    }

    @Override
    public SkuName sku() {
        return this.innerModel().sku();
    }

    @Override
    public List<String> zones() {
        List<String> inner = this.innerModel().zones();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public float storageCapacityTiB() {
        return this.innerModel().storageCapacityTiB().floatValue();
    }

    @Override
    public AmlFilesystemHealth health() {
        return this.innerModel().health();
    }

    @Override
    public AmlFilesystemProvisioningStateType provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public String filesystemSubnet() {
        return this.innerModel().filesystemSubnet();
    }

    @Override
    public AmlFilesystemClientInfo clientInfo() {
        return this.innerModel().clientInfo();
    }

    @Override
    public Integer throughputProvisionedMBps() {
        return this.innerModel().throughputProvisionedMBps();
    }

    @Override
    public AmlFilesystemEncryptionSettings encryptionSettings() {
        return this.innerModel().encryptionSettings();
    }

    @Override
    public AmlFilesystemPropertiesMaintenanceWindow maintenanceWindow() {
        return this.innerModel().maintenanceWindow();
    }

    @Override
    public AmlFilesystemPropertiesHsm hsm() {
        return this.innerModel().hsm();
    }

    @Override
    public AmlFilesystemRootSquashSettings rootSquashSettings() {
        return this.innerModel().rootSquashSettings();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public AmlFilesystemInner innerModel() {
        return this.innerObject;
    }

    private StorageCacheManager manager() {
        return this.serviceManager;
    }

    @Override
    public AmlFilesystemImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public AmlFilesystem create() {
        this.innerObject = this.serviceManager.serviceClient().getAmlFilesystems().createOrUpdate(this.resourceGroupName, this.amlFilesystemName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public AmlFilesystem create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getAmlFilesystems().createOrUpdate(this.resourceGroupName, this.amlFilesystemName, this.innerModel(), context);
        return this;
    }

    AmlFilesystemImpl(String name, StorageCacheManager serviceManager) {
        this.innerObject = new AmlFilesystemInner();
        this.serviceManager = serviceManager;
        this.amlFilesystemName = name;
    }

    @Override
    public AmlFilesystemImpl update() {
        this.updateAmlFilesystem = new AmlFilesystemUpdate();
        return this;
    }

    @Override
    public AmlFilesystem apply() {
        this.innerObject = this.serviceManager.serviceClient().getAmlFilesystems().update(this.resourceGroupName, this.amlFilesystemName, this.updateAmlFilesystem, Context.NONE);
        return this;
    }

    @Override
    public AmlFilesystem apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getAmlFilesystems().update(this.resourceGroupName, this.amlFilesystemName, this.updateAmlFilesystem, context);
        return this;
    }

    AmlFilesystemImpl(AmlFilesystemInner innerObject, StorageCacheManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.amlFilesystemName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "amlFilesystems");
    }

    @Override
    public AmlFilesystem refresh() {
        this.innerObject = (AmlFilesystemInner)((Object)this.serviceManager.serviceClient().getAmlFilesystems().getByResourceGroupWithResponse(this.resourceGroupName, this.amlFilesystemName, Context.NONE).getValue());
        return this;
    }

    @Override
    public AmlFilesystem refresh(Context context) {
        this.innerObject = (AmlFilesystemInner)((Object)this.serviceManager.serviceClient().getAmlFilesystems().getByResourceGroupWithResponse(this.resourceGroupName, this.amlFilesystemName, context).getValue());
        return this;
    }

    @Override
    public Response<Void> archiveWithResponse(AmlFilesystemArchiveInfo archiveInfo, Context context) {
        return this.serviceManager.amlFilesystems().archiveWithResponse(this.resourceGroupName, this.amlFilesystemName, archiveInfo, context);
    }

    @Override
    public void archive() {
        this.serviceManager.amlFilesystems().archive(this.resourceGroupName, this.amlFilesystemName);
    }

    @Override
    public Response<Void> cancelArchiveWithResponse(Context context) {
        return this.serviceManager.amlFilesystems().cancelArchiveWithResponse(this.resourceGroupName, this.amlFilesystemName, context);
    }

    @Override
    public void cancelArchive() {
        this.serviceManager.amlFilesystems().cancelArchive(this.resourceGroupName, this.amlFilesystemName);
    }

    @Override
    public AmlFilesystemImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public AmlFilesystemImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public AmlFilesystemImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateAmlFilesystem.withTags(tags);
        return this;
    }

    @Override
    public AmlFilesystemImpl withIdentity(AmlFilesystemIdentity identity) {
        this.innerModel().withIdentity(identity);
        return this;
    }

    @Override
    public AmlFilesystemImpl withSku(SkuName sku) {
        this.innerModel().withSku(sku);
        return this;
    }

    @Override
    public AmlFilesystemImpl withZones(List<String> zones) {
        this.innerModel().withZones(zones);
        return this;
    }

    @Override
    public AmlFilesystemImpl withStorageCapacityTiB(float storageCapacityTiB) {
        this.innerModel().withStorageCapacityTiB(Float.valueOf(storageCapacityTiB));
        return this;
    }

    @Override
    public AmlFilesystemImpl withFilesystemSubnet(String filesystemSubnet) {
        this.innerModel().withFilesystemSubnet(filesystemSubnet);
        return this;
    }

    @Override
    public AmlFilesystemImpl withEncryptionSettings(AmlFilesystemEncryptionSettings encryptionSettings) {
        if (this.isInCreateMode()) {
            this.innerModel().withEncryptionSettings(encryptionSettings);
            return this;
        }
        this.updateAmlFilesystem.withEncryptionSettings(encryptionSettings);
        return this;
    }

    @Override
    public AmlFilesystemImpl withMaintenanceWindow(AmlFilesystemPropertiesMaintenanceWindow maintenanceWindow) {
        this.innerModel().withMaintenanceWindow(maintenanceWindow);
        return this;
    }

    @Override
    public AmlFilesystemImpl withHsm(AmlFilesystemPropertiesHsm hsm) {
        this.innerModel().withHsm(hsm);
        return this;
    }

    @Override
    public AmlFilesystemImpl withRootSquashSettings(AmlFilesystemRootSquashSettings rootSquashSettings) {
        if (this.isInCreateMode()) {
            this.innerModel().withRootSquashSettings(rootSquashSettings);
            return this;
        }
        this.updateAmlFilesystem.withRootSquashSettings(rootSquashSettings);
        return this;
    }

    @Override
    public AmlFilesystemImpl withMaintenanceWindow(AmlFilesystemUpdatePropertiesMaintenanceWindow maintenanceWindow) {
        this.updateAmlFilesystem.withMaintenanceWindow(maintenanceWindow);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

