/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storagecache.models.ResourceSkuCapabilities;
import com.azure.resourcemanager.storagecache.models.ResourceSkuLocationInfo;
import com.azure.resourcemanager.storagecache.models.Restriction;
import java.io.IOException;
import java.util.List;

public final class ResourceSkuInner
implements JsonSerializable<ResourceSkuInner> {
    private String resourceType;
    private List<ResourceSkuCapabilities> capabilities;
    private List<String> locations;
    private List<ResourceSkuLocationInfo> locationInfo;
    private String name;
    private List<Restriction> restrictions;

    public String resourceType() {
        return this.resourceType;
    }

    public List<ResourceSkuCapabilities> capabilities() {
        return this.capabilities;
    }

    public ResourceSkuInner withCapabilities(List<ResourceSkuCapabilities> capabilities) {
        this.capabilities = capabilities;
        return this;
    }

    public List<String> locations() {
        return this.locations;
    }

    public List<ResourceSkuLocationInfo> locationInfo() {
        return this.locationInfo;
    }

    public ResourceSkuInner withLocationInfo(List<ResourceSkuLocationInfo> locationInfo) {
        this.locationInfo = locationInfo;
        return this;
    }

    public String name() {
        return this.name;
    }

    public ResourceSkuInner withName(String name) {
        this.name = name;
        return this;
    }

    public List<Restriction> restrictions() {
        return this.restrictions;
    }

    public ResourceSkuInner withRestrictions(List<Restriction> restrictions) {
        this.restrictions = restrictions;
        return this;
    }

    public void validate() {
        if (this.capabilities() != null) {
            this.capabilities().forEach(e -> e.validate());
        }
        if (this.locationInfo() != null) {
            this.locationInfo().forEach(e -> e.validate());
        }
        if (this.restrictions() != null) {
            this.restrictions().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("capabilities", this.capabilities, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("locationInfo", this.locationInfo, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeArrayField("restrictions", this.restrictions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ResourceSkuInner fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceSkuInner)jsonReader.readObject(reader -> {
            ResourceSkuInner deserializedResourceSkuInner = new ResourceSkuInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("resourceType".equals(fieldName)) {
                    deserializedResourceSkuInner.resourceType = reader.getString();
                    continue;
                }
                if ("capabilities".equals(fieldName)) {
                    List capabilities;
                    deserializedResourceSkuInner.capabilities = capabilities = reader.readArray(reader1 -> ResourceSkuCapabilities.fromJson(reader1));
                    continue;
                }
                if ("locations".equals(fieldName)) {
                    List locations;
                    deserializedResourceSkuInner.locations = locations = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("locationInfo".equals(fieldName)) {
                    List locationInfo;
                    deserializedResourceSkuInner.locationInfo = locationInfo = reader.readArray(reader1 -> ResourceSkuLocationInfo.fromJson(reader1));
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedResourceSkuInner.name = reader.getString();
                    continue;
                }
                if ("restrictions".equals(fieldName)) {
                    List restrictions;
                    deserializedResourceSkuInner.restrictions = restrictions = reader.readArray(reader1 -> Restriction.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceSkuInner;
        });
    }
}

