/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storagecache.fluent.models.CacheProperties;
import com.azure.resourcemanager.storagecache.models.CacheDirectorySettings;
import com.azure.resourcemanager.storagecache.models.CacheEncryptionSettings;
import com.azure.resourcemanager.storagecache.models.CacheHealth;
import com.azure.resourcemanager.storagecache.models.CacheIdentity;
import com.azure.resourcemanager.storagecache.models.CacheNetworkSettings;
import com.azure.resourcemanager.storagecache.models.CacheSecuritySettings;
import com.azure.resourcemanager.storagecache.models.CacheSku;
import com.azure.resourcemanager.storagecache.models.CacheUpgradeSettings;
import com.azure.resourcemanager.storagecache.models.CacheUpgradeStatus;
import com.azure.resourcemanager.storagecache.models.PrimingJob;
import com.azure.resourcemanager.storagecache.models.ProvisioningStateType;
import com.azure.resourcemanager.storagecache.models.StorageTargetSpaceAllocation;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class CacheInner
extends Resource {
    private CacheIdentity identity;
    private SystemData systemData;
    private CacheProperties innerProperties;
    private CacheSku sku;
    private String type;
    private String name;
    private String id;

    public CacheIdentity identity() {
        return this.identity;
    }

    public CacheInner withIdentity(CacheIdentity identity) {
        this.identity = identity;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    private CacheProperties innerProperties() {
        return this.innerProperties;
    }

    public CacheSku sku() {
        return this.sku;
    }

    public CacheInner withSku(CacheSku sku) {
        this.sku = sku;
        return this;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public CacheInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public CacheInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public Integer cacheSizeGB() {
        return this.innerProperties() == null ? null : this.innerProperties().cacheSizeGB();
    }

    public CacheInner withCacheSizeGB(Integer cacheSizeGB) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CacheProperties();
        }
        this.innerProperties().withCacheSizeGB(cacheSizeGB);
        return this;
    }

    public CacheHealth health() {
        return this.innerProperties() == null ? null : this.innerProperties().health();
    }

    public List<String> mountAddresses() {
        return this.innerProperties() == null ? null : this.innerProperties().mountAddresses();
    }

    public ProvisioningStateType provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String subnet() {
        return this.innerProperties() == null ? null : this.innerProperties().subnet();
    }

    public CacheInner withSubnet(String subnet) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CacheProperties();
        }
        this.innerProperties().withSubnet(subnet);
        return this;
    }

    public CacheUpgradeStatus upgradeStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().upgradeStatus();
    }

    public CacheUpgradeSettings upgradeSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().upgradeSettings();
    }

    public CacheInner withUpgradeSettings(CacheUpgradeSettings upgradeSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CacheProperties();
        }
        this.innerProperties().withUpgradeSettings(upgradeSettings);
        return this;
    }

    public CacheNetworkSettings networkSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().networkSettings();
    }

    public CacheInner withNetworkSettings(CacheNetworkSettings networkSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CacheProperties();
        }
        this.innerProperties().withNetworkSettings(networkSettings);
        return this;
    }

    public CacheEncryptionSettings encryptionSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().encryptionSettings();
    }

    public CacheInner withEncryptionSettings(CacheEncryptionSettings encryptionSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CacheProperties();
        }
        this.innerProperties().withEncryptionSettings(encryptionSettings);
        return this;
    }

    public CacheSecuritySettings securitySettings() {
        return this.innerProperties() == null ? null : this.innerProperties().securitySettings();
    }

    public CacheInner withSecuritySettings(CacheSecuritySettings securitySettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CacheProperties();
        }
        this.innerProperties().withSecuritySettings(securitySettings);
        return this;
    }

    public CacheDirectorySettings directoryServicesSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().directoryServicesSettings();
    }

    public CacheInner withDirectoryServicesSettings(CacheDirectorySettings directoryServicesSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CacheProperties();
        }
        this.innerProperties().withDirectoryServicesSettings(directoryServicesSettings);
        return this;
    }

    public List<String> zones() {
        return this.innerProperties() == null ? null : this.innerProperties().zones();
    }

    public CacheInner withZones(List<String> zones) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CacheProperties();
        }
        this.innerProperties().withZones(zones);
        return this;
    }

    public List<PrimingJob> primingJobs() {
        return this.innerProperties() == null ? null : this.innerProperties().primingJobs();
    }

    public List<StorageTargetSpaceAllocation> spaceAllocation() {
        return this.innerProperties() == null ? null : this.innerProperties().spaceAllocation();
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        return jsonWriter.writeEndObject();
    }

    public static CacheInner fromJson(JsonReader jsonReader) throws IOException {
        return (CacheInner)((Object)jsonReader.readObject(reader -> {
            CacheInner deserializedCacheInner = new CacheInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedCacheInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedCacheInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedCacheInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedCacheInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedCacheInner.withTags(tags);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedCacheInner.identity = CacheIdentity.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedCacheInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedCacheInner.innerProperties = CacheProperties.fromJson(reader);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedCacheInner.sku = CacheSku.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCacheInner;
        }));
    }
}

