/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storagecache.models.AutoImportJobPropertiesStatusBlobSyncEvents;
import com.azure.resourcemanager.storagecache.models.AutoImportJobState;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class AutoImportJobPropertiesStatus
implements JsonSerializable<AutoImportJobPropertiesStatus> {
    private AutoImportJobState state;
    private String statusCode;
    private String statusMessage;
    private OffsetDateTime scanStartTime;
    private OffsetDateTime scanEndTime;
    private Long totalBlobsWalked;
    private Long rateOfBlobWalk;
    private Long totalBlobsImported;
    private Long rateOfBlobImport;
    private Long importedFiles;
    private Long importedDirectories;
    private Long importedSymlinks;
    private Long preexistingFiles;
    private Long preexistingDirectories;
    private Long preexistingSymlinks;
    private Long totalErrors;
    private Long totalConflicts;
    private AutoImportJobPropertiesStatusBlobSyncEvents blobSyncEvents;
    private OffsetDateTime lastStartedTimeUtc;
    private OffsetDateTime lastCompletionTimeUtc;

    public AutoImportJobState state() {
        return this.state;
    }

    public String statusCode() {
        return this.statusCode;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public OffsetDateTime scanStartTime() {
        return this.scanStartTime;
    }

    public OffsetDateTime scanEndTime() {
        return this.scanEndTime;
    }

    public Long totalBlobsWalked() {
        return this.totalBlobsWalked;
    }

    public Long rateOfBlobWalk() {
        return this.rateOfBlobWalk;
    }

    public Long totalBlobsImported() {
        return this.totalBlobsImported;
    }

    public Long rateOfBlobImport() {
        return this.rateOfBlobImport;
    }

    public Long importedFiles() {
        return this.importedFiles;
    }

    public Long importedDirectories() {
        return this.importedDirectories;
    }

    public Long importedSymlinks() {
        return this.importedSymlinks;
    }

    public Long preexistingFiles() {
        return this.preexistingFiles;
    }

    public Long preexistingDirectories() {
        return this.preexistingDirectories;
    }

    public Long preexistingSymlinks() {
        return this.preexistingSymlinks;
    }

    public Long totalErrors() {
        return this.totalErrors;
    }

    public Long totalConflicts() {
        return this.totalConflicts;
    }

    public AutoImportJobPropertiesStatusBlobSyncEvents blobSyncEvents() {
        return this.blobSyncEvents;
    }

    public OffsetDateTime lastStartedTimeUtc() {
        return this.lastStartedTimeUtc;
    }

    public OffsetDateTime lastCompletionTimeUtc() {
        return this.lastCompletionTimeUtc;
    }

    public void validate() {
        if (this.blobSyncEvents() != null) {
            this.blobSyncEvents().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static AutoImportJobPropertiesStatus fromJson(JsonReader jsonReader) throws IOException {
        return (AutoImportJobPropertiesStatus)jsonReader.readObject(reader -> {
            AutoImportJobPropertiesStatus deserializedAutoImportJobPropertiesStatus = new AutoImportJobPropertiesStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("state".equals(fieldName)) {
                    deserializedAutoImportJobPropertiesStatus.state = AutoImportJobState.fromString(reader.getString());
                    continue;
                }
                if ("statusCode".equals(fieldName)) {
                    deserializedAutoImportJobPropertiesStatus.statusCode = reader.getString();
                    continue;
                }
                if ("statusMessage".equals(fieldName)) {
                    deserializedAutoImportJobPropertiesStatus.statusMessage = reader.getString();
                    continue;
                }
                if ("scanStartTime".equals(fieldName)) {
                    deserializedAutoImportJobPropertiesStatus.scanStartTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("scanEndTime".equals(fieldName)) {
                    deserializedAutoImportJobPropertiesStatus.scanEndTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("totalBlobsWalked".equals(fieldName)) {
                    deserializedAutoImportJobPropertiesStatus.totalBlobsWalked = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("rateOfBlobWalk".equals(fieldName)) {
                    deserializedAutoImportJobPropertiesStatus.rateOfBlobWalk = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("totalBlobsImported".equals(fieldName)) {
                    deserializedAutoImportJobPropertiesStatus.totalBlobsImported = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("rateOfBlobImport".equals(fieldName)) {
                    deserializedAutoImportJobPropertiesStatus.rateOfBlobImport = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("importedFiles".equals(fieldName)) {
                    deserializedAutoImportJobPropertiesStatus.importedFiles = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("importedDirectories".equals(fieldName)) {
                    deserializedAutoImportJobPropertiesStatus.importedDirectories = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("importedSymlinks".equals(fieldName)) {
                    deserializedAutoImportJobPropertiesStatus.importedSymlinks = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("preexistingFiles".equals(fieldName)) {
                    deserializedAutoImportJobPropertiesStatus.preexistingFiles = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("preexistingDirectories".equals(fieldName)) {
                    deserializedAutoImportJobPropertiesStatus.preexistingDirectories = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("preexistingSymlinks".equals(fieldName)) {
                    deserializedAutoImportJobPropertiesStatus.preexistingSymlinks = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("totalErrors".equals(fieldName)) {
                    deserializedAutoImportJobPropertiesStatus.totalErrors = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("totalConflicts".equals(fieldName)) {
                    deserializedAutoImportJobPropertiesStatus.totalConflicts = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("blobSyncEvents".equals(fieldName)) {
                    deserializedAutoImportJobPropertiesStatus.blobSyncEvents = AutoImportJobPropertiesStatusBlobSyncEvents.fromJson(reader);
                    continue;
                }
                if ("lastStartedTimeUTC".equals(fieldName)) {
                    deserializedAutoImportJobPropertiesStatus.lastStartedTimeUtc = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastCompletionTimeUTC".equals(fieldName)) {
                    deserializedAutoImportJobPropertiesStatus.lastCompletionTimeUtc = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAutoImportJobPropertiesStatus;
        });
    }
}

