/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storagecache.fluent.models.AutoImportJobProperties;
import com.azure.resourcemanager.storagecache.models.AutoImportJobPropertiesAdminStatus;
import com.azure.resourcemanager.storagecache.models.AutoImportJobPropertiesProvisioningState;
import com.azure.resourcemanager.storagecache.models.AutoImportJobPropertiesStatusBlobSyncEvents;
import com.azure.resourcemanager.storagecache.models.AutoImportJobState;
import com.azure.resourcemanager.storagecache.models.ConflictResolutionMode;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class AutoImportJobInner
extends Resource {
    private AutoImportJobProperties innerProperties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private AutoImportJobProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public AutoImportJobInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public AutoImportJobInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public AutoImportJobPropertiesProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public AutoImportJobPropertiesAdminStatus adminStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().adminStatus();
    }

    public AutoImportJobInner withAdminStatus(AutoImportJobPropertiesAdminStatus adminStatus) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AutoImportJobProperties();
        }
        this.innerProperties().withAdminStatus(adminStatus);
        return this;
    }

    public List<String> autoImportPrefixes() {
        return this.innerProperties() == null ? null : this.innerProperties().autoImportPrefixes();
    }

    public AutoImportJobInner withAutoImportPrefixes(List<String> autoImportPrefixes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AutoImportJobProperties();
        }
        this.innerProperties().withAutoImportPrefixes(autoImportPrefixes);
        return this;
    }

    public ConflictResolutionMode conflictResolutionMode() {
        return this.innerProperties() == null ? null : this.innerProperties().conflictResolutionMode();
    }

    public AutoImportJobInner withConflictResolutionMode(ConflictResolutionMode conflictResolutionMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AutoImportJobProperties();
        }
        this.innerProperties().withConflictResolutionMode(conflictResolutionMode);
        return this;
    }

    public Boolean enableDeletions() {
        return this.innerProperties() == null ? null : this.innerProperties().enableDeletions();
    }

    public AutoImportJobInner withEnableDeletions(Boolean enableDeletions) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AutoImportJobProperties();
        }
        this.innerProperties().withEnableDeletions(enableDeletions);
        return this;
    }

    public Long maximumErrors() {
        return this.innerProperties() == null ? null : this.innerProperties().maximumErrors();
    }

    public AutoImportJobInner withMaximumErrors(Long maximumErrors) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AutoImportJobProperties();
        }
        this.innerProperties().withMaximumErrors(maximumErrors);
        return this;
    }

    public AutoImportJobState state() {
        return this.innerProperties() == null ? null : this.innerProperties().state();
    }

    public String statusCode() {
        return this.innerProperties() == null ? null : this.innerProperties().statusCode();
    }

    public String statusMessage() {
        return this.innerProperties() == null ? null : this.innerProperties().statusMessage();
    }

    public OffsetDateTime scanStartTime() {
        return this.innerProperties() == null ? null : this.innerProperties().scanStartTime();
    }

    public OffsetDateTime scanEndTime() {
        return this.innerProperties() == null ? null : this.innerProperties().scanEndTime();
    }

    public Long totalBlobsWalked() {
        return this.innerProperties() == null ? null : this.innerProperties().totalBlobsWalked();
    }

    public Long rateOfBlobWalk() {
        return this.innerProperties() == null ? null : this.innerProperties().rateOfBlobWalk();
    }

    public Long totalBlobsImported() {
        return this.innerProperties() == null ? null : this.innerProperties().totalBlobsImported();
    }

    public Long rateOfBlobImport() {
        return this.innerProperties() == null ? null : this.innerProperties().rateOfBlobImport();
    }

    public Long importedFiles() {
        return this.innerProperties() == null ? null : this.innerProperties().importedFiles();
    }

    public Long importedDirectories() {
        return this.innerProperties() == null ? null : this.innerProperties().importedDirectories();
    }

    public Long importedSymlinks() {
        return this.innerProperties() == null ? null : this.innerProperties().importedSymlinks();
    }

    public Long preexistingFiles() {
        return this.innerProperties() == null ? null : this.innerProperties().preexistingFiles();
    }

    public Long preexistingDirectories() {
        return this.innerProperties() == null ? null : this.innerProperties().preexistingDirectories();
    }

    public Long preexistingSymlinks() {
        return this.innerProperties() == null ? null : this.innerProperties().preexistingSymlinks();
    }

    public Long totalErrors() {
        return this.innerProperties() == null ? null : this.innerProperties().totalErrors();
    }

    public Long totalConflicts() {
        return this.innerProperties() == null ? null : this.innerProperties().totalConflicts();
    }

    public AutoImportJobPropertiesStatusBlobSyncEvents blobSyncEvents() {
        return this.innerProperties() == null ? null : this.innerProperties().blobSyncEvents();
    }

    public OffsetDateTime lastStartedTimeUtc() {
        return this.innerProperties() == null ? null : this.innerProperties().lastStartedTimeUtc();
    }

    public OffsetDateTime lastCompletionTimeUtc() {
        return this.innerProperties() == null ? null : this.innerProperties().lastCompletionTimeUtc();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static AutoImportJobInner fromJson(JsonReader jsonReader) throws IOException {
        return (AutoImportJobInner)((Object)jsonReader.readObject(reader -> {
            AutoImportJobInner deserializedAutoImportJobInner = new AutoImportJobInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedAutoImportJobInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedAutoImportJobInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAutoImportJobInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedAutoImportJobInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedAutoImportJobInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedAutoImportJobInner.innerProperties = AutoImportJobProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedAutoImportJobInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAutoImportJobInner;
        }));
    }
}

