/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storagecache.fluent.models.AutoExportJobPropertiesStatus;
import com.azure.resourcemanager.storagecache.models.AutoExportJobAdminStatus;
import com.azure.resourcemanager.storagecache.models.AutoExportJobProvisioningStateType;
import com.azure.resourcemanager.storagecache.models.AutoExportStatusType;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class AutoExportJobProperties
implements JsonSerializable<AutoExportJobProperties> {
    private AutoExportJobProvisioningStateType provisioningState;
    private AutoExportJobAdminStatus adminStatus;
    private List<String> autoExportPrefixes;
    private AutoExportJobPropertiesStatus innerStatus;

    public AutoExportJobProvisioningStateType provisioningState() {
        return this.provisioningState;
    }

    public AutoExportJobAdminStatus adminStatus() {
        return this.adminStatus;
    }

    public AutoExportJobProperties withAdminStatus(AutoExportJobAdminStatus adminStatus) {
        this.adminStatus = adminStatus;
        return this;
    }

    public List<String> autoExportPrefixes() {
        return this.autoExportPrefixes;
    }

    public AutoExportJobProperties withAutoExportPrefixes(List<String> autoExportPrefixes) {
        this.autoExportPrefixes = autoExportPrefixes;
        return this;
    }

    private AutoExportJobPropertiesStatus innerStatus() {
        return this.innerStatus;
    }

    public AutoExportStatusType state() {
        return this.innerStatus() == null ? null : this.innerStatus().state();
    }

    public String statusCode() {
        return this.innerStatus() == null ? null : this.innerStatus().statusCode();
    }

    public String statusMessage() {
        return this.innerStatus() == null ? null : this.innerStatus().statusMessage();
    }

    public Long totalFilesExported() {
        return this.innerStatus() == null ? null : this.innerStatus().totalFilesExported();
    }

    public Long totalMiBExported() {
        return this.innerStatus() == null ? null : this.innerStatus().totalMiBExported();
    }

    public Long totalFilesFailed() {
        return this.innerStatus() == null ? null : this.innerStatus().totalFilesFailed();
    }

    public Integer exportIterationCount() {
        return this.innerStatus() == null ? null : this.innerStatus().exportIterationCount();
    }

    public OffsetDateTime lastSuccessfulIterationCompletionTimeUtc() {
        return this.innerStatus() == null ? null : this.innerStatus().lastSuccessfulIterationCompletionTimeUtc();
    }

    public Long currentIterationFilesDiscovered() {
        return this.innerStatus() == null ? null : this.innerStatus().currentIterationFilesDiscovered();
    }

    public Long currentIterationMiBDiscovered() {
        return this.innerStatus() == null ? null : this.innerStatus().currentIterationMiBDiscovered();
    }

    public Long currentIterationFilesExported() {
        return this.innerStatus() == null ? null : this.innerStatus().currentIterationFilesExported();
    }

    public Long currentIterationMiBExported() {
        return this.innerStatus() == null ? null : this.innerStatus().currentIterationMiBExported();
    }

    public Long currentIterationFilesFailed() {
        return this.innerStatus() == null ? null : this.innerStatus().currentIterationFilesFailed();
    }

    public OffsetDateTime lastStartedTimeUtc() {
        return this.innerStatus() == null ? null : this.innerStatus().lastStartedTimeUtc();
    }

    public OffsetDateTime lastCompletionTimeUtc() {
        return this.innerStatus() == null ? null : this.innerStatus().lastCompletionTimeUtc();
    }

    public void validate() {
        if (this.innerStatus() != null) {
            this.innerStatus().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("adminStatus", this.adminStatus == null ? null : this.adminStatus.toString());
        jsonWriter.writeArrayField("autoExportPrefixes", this.autoExportPrefixes, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static AutoExportJobProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AutoExportJobProperties)jsonReader.readObject(reader -> {
            AutoExportJobProperties deserializedAutoExportJobProperties = new AutoExportJobProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedAutoExportJobProperties.provisioningState = AutoExportJobProvisioningStateType.fromString(reader.getString());
                    continue;
                }
                if ("adminStatus".equals(fieldName)) {
                    deserializedAutoExportJobProperties.adminStatus = AutoExportJobAdminStatus.fromString(reader.getString());
                    continue;
                }
                if ("autoExportPrefixes".equals(fieldName)) {
                    List autoExportPrefixes;
                    deserializedAutoExportJobProperties.autoExportPrefixes = autoExportPrefixes = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedAutoExportJobProperties.innerStatus = AutoExportJobPropertiesStatus.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAutoExportJobProperties;
        });
    }
}

