/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storagecache.fluent.models.AscOperationProperties;
import com.azure.resourcemanager.storagecache.models.AscOperationErrorResponse;
import java.io.IOException;
import java.util.Map;

public final class AscOperationInner
implements JsonSerializable<AscOperationInner> {
    private String id;
    private String name;
    private String startTime;
    private String endTime;
    private String status;
    private AscOperationErrorResponse error;
    private AscOperationProperties innerProperties;

    public String id() {
        return this.id;
    }

    public AscOperationInner withId(String id) {
        this.id = id;
        return this;
    }

    public String name() {
        return this.name;
    }

    public AscOperationInner withName(String name) {
        this.name = name;
        return this;
    }

    public String startTime() {
        return this.startTime;
    }

    public AscOperationInner withStartTime(String startTime) {
        this.startTime = startTime;
        return this;
    }

    public String endTime() {
        return this.endTime;
    }

    public AscOperationInner withEndTime(String endTime) {
        this.endTime = endTime;
        return this;
    }

    public String status() {
        return this.status;
    }

    public AscOperationInner withStatus(String status) {
        this.status = status;
        return this;
    }

    public AscOperationErrorResponse error() {
        return this.error;
    }

    public AscOperationInner withError(AscOperationErrorResponse error) {
        this.error = error;
        return this;
    }

    private AscOperationProperties innerProperties() {
        return this.innerProperties;
    }

    public Map<String, Object> output() {
        return this.innerProperties() == null ? null : this.innerProperties().output();
    }

    public AscOperationInner withOutput(Map<String, Object> output) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AscOperationProperties();
        }
        this.innerProperties().withOutput(output);
        return this;
    }

    public void validate() {
        if (this.error() != null) {
            this.error().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("startTime", this.startTime);
        jsonWriter.writeStringField("endTime", this.endTime);
        jsonWriter.writeStringField("status", this.status);
        jsonWriter.writeJsonField("error", (JsonSerializable)this.error);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static AscOperationInner fromJson(JsonReader jsonReader) throws IOException {
        return (AscOperationInner)jsonReader.readObject(reader -> {
            AscOperationInner deserializedAscOperationInner = new AscOperationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedAscOperationInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedAscOperationInner.name = reader.getString();
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedAscOperationInner.startTime = reader.getString();
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedAscOperationInner.endTime = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedAscOperationInner.status = reader.getString();
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedAscOperationInner.error = AscOperationErrorResponse.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedAscOperationInner.innerProperties = AscOperationProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAscOperationInner;
        });
    }
}

