/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storagecache.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storagecache.models.AmlFilesystemClientInfo;
import com.azure.resourcemanager.storagecache.models.AmlFilesystemEncryptionSettings;
import com.azure.resourcemanager.storagecache.models.AmlFilesystemHealth;
import com.azure.resourcemanager.storagecache.models.AmlFilesystemPropertiesHsm;
import com.azure.resourcemanager.storagecache.models.AmlFilesystemPropertiesMaintenanceWindow;
import com.azure.resourcemanager.storagecache.models.AmlFilesystemProvisioningStateType;
import com.azure.resourcemanager.storagecache.models.AmlFilesystemRootSquashSettings;
import java.io.IOException;

public final class AmlFilesystemProperties
implements JsonSerializable<AmlFilesystemProperties> {
    private float storageCapacityTiB;
    private AmlFilesystemHealth health;
    private AmlFilesystemProvisioningStateType provisioningState;
    private String filesystemSubnet;
    private AmlFilesystemClientInfo clientInfo;
    private Integer throughputProvisionedMBps;
    private AmlFilesystemEncryptionSettings encryptionSettings;
    private AmlFilesystemPropertiesMaintenanceWindow maintenanceWindow;
    private AmlFilesystemPropertiesHsm hsm;
    private AmlFilesystemRootSquashSettings rootSquashSettings;
    private static final ClientLogger LOGGER = new ClientLogger(AmlFilesystemProperties.class);

    public float storageCapacityTiB() {
        return this.storageCapacityTiB;
    }

    public AmlFilesystemProperties withStorageCapacityTiB(float storageCapacityTiB) {
        this.storageCapacityTiB = storageCapacityTiB;
        return this;
    }

    public AmlFilesystemHealth health() {
        return this.health;
    }

    public AmlFilesystemProvisioningStateType provisioningState() {
        return this.provisioningState;
    }

    public String filesystemSubnet() {
        return this.filesystemSubnet;
    }

    public AmlFilesystemProperties withFilesystemSubnet(String filesystemSubnet) {
        this.filesystemSubnet = filesystemSubnet;
        return this;
    }

    public AmlFilesystemClientInfo clientInfo() {
        return this.clientInfo;
    }

    public Integer throughputProvisionedMBps() {
        return this.throughputProvisionedMBps;
    }

    public AmlFilesystemEncryptionSettings encryptionSettings() {
        return this.encryptionSettings;
    }

    public AmlFilesystemProperties withEncryptionSettings(AmlFilesystemEncryptionSettings encryptionSettings) {
        this.encryptionSettings = encryptionSettings;
        return this;
    }

    public AmlFilesystemPropertiesMaintenanceWindow maintenanceWindow() {
        return this.maintenanceWindow;
    }

    public AmlFilesystemProperties withMaintenanceWindow(AmlFilesystemPropertiesMaintenanceWindow maintenanceWindow) {
        this.maintenanceWindow = maintenanceWindow;
        return this;
    }

    public AmlFilesystemPropertiesHsm hsm() {
        return this.hsm;
    }

    public AmlFilesystemProperties withHsm(AmlFilesystemPropertiesHsm hsm) {
        this.hsm = hsm;
        return this;
    }

    public AmlFilesystemRootSquashSettings rootSquashSettings() {
        return this.rootSquashSettings;
    }

    public AmlFilesystemProperties withRootSquashSettings(AmlFilesystemRootSquashSettings rootSquashSettings) {
        this.rootSquashSettings = rootSquashSettings;
        return this;
    }

    public void validate() {
        if (this.health() != null) {
            this.health().validate();
        }
        if (this.filesystemSubnet() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property filesystemSubnet in model AmlFilesystemProperties"));
        }
        if (this.clientInfo() != null) {
            this.clientInfo().validate();
        }
        if (this.encryptionSettings() != null) {
            this.encryptionSettings().validate();
        }
        if (this.maintenanceWindow() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property maintenanceWindow in model AmlFilesystemProperties"));
        }
        this.maintenanceWindow().validate();
        if (this.hsm() != null) {
            this.hsm().validate();
        }
        if (this.rootSquashSettings() != null) {
            this.rootSquashSettings().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeFloatField("storageCapacityTiB", this.storageCapacityTiB);
        jsonWriter.writeStringField("filesystemSubnet", this.filesystemSubnet);
        jsonWriter.writeJsonField("maintenanceWindow", (JsonSerializable)this.maintenanceWindow);
        jsonWriter.writeJsonField("encryptionSettings", (JsonSerializable)this.encryptionSettings);
        jsonWriter.writeJsonField("hsm", (JsonSerializable)this.hsm);
        jsonWriter.writeJsonField("rootSquashSettings", (JsonSerializable)this.rootSquashSettings);
        return jsonWriter.writeEndObject();
    }

    public static AmlFilesystemProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AmlFilesystemProperties)jsonReader.readObject(reader -> {
            AmlFilesystemProperties deserializedAmlFilesystemProperties = new AmlFilesystemProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("storageCapacityTiB".equals(fieldName)) {
                    deserializedAmlFilesystemProperties.storageCapacityTiB = reader.getFloat();
                    continue;
                }
                if ("filesystemSubnet".equals(fieldName)) {
                    deserializedAmlFilesystemProperties.filesystemSubnet = reader.getString();
                    continue;
                }
                if ("maintenanceWindow".equals(fieldName)) {
                    deserializedAmlFilesystemProperties.maintenanceWindow = AmlFilesystemPropertiesMaintenanceWindow.fromJson(reader);
                    continue;
                }
                if ("health".equals(fieldName)) {
                    deserializedAmlFilesystemProperties.health = AmlFilesystemHealth.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedAmlFilesystemProperties.provisioningState = AmlFilesystemProvisioningStateType.fromString(reader.getString());
                    continue;
                }
                if ("clientInfo".equals(fieldName)) {
                    deserializedAmlFilesystemProperties.clientInfo = AmlFilesystemClientInfo.fromJson(reader);
                    continue;
                }
                if ("throughputProvisionedMBps".equals(fieldName)) {
                    deserializedAmlFilesystemProperties.throughputProvisionedMBps = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("encryptionSettings".equals(fieldName)) {
                    deserializedAmlFilesystemProperties.encryptionSettings = AmlFilesystemEncryptionSettings.fromJson(reader);
                    continue;
                }
                if ("hsm".equals(fieldName)) {
                    deserializedAmlFilesystemProperties.hsm = AmlFilesystemPropertiesHsm.fromJson(reader);
                    continue;
                }
                if ("rootSquashSettings".equals(fieldName)) {
                    deserializedAmlFilesystemProperties.rootSquashSettings = AmlFilesystemRootSquashSettings.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAmlFilesystemProperties;
        });
    }
}

