/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.models.StorageAccountInternetEndpoints;
import com.azure.resourcemanager.storage.models.StorageAccountIpv6Endpoints;
import com.azure.resourcemanager.storage.models.StorageAccountMicrosoftEndpoints;
import java.io.IOException;

public final class Endpoints
implements JsonSerializable<Endpoints> {
    private String blob;
    private String queue;
    private String table;
    private String file;
    private String web;
    private String dfs;
    private StorageAccountMicrosoftEndpoints microsoftEndpoints;
    private StorageAccountInternetEndpoints internetEndpoints;
    private StorageAccountIpv6Endpoints ipv6Endpoints;

    public String blob() {
        return this.blob;
    }

    public String queue() {
        return this.queue;
    }

    public String table() {
        return this.table;
    }

    public String file() {
        return this.file;
    }

    public String web() {
        return this.web;
    }

    public String dfs() {
        return this.dfs;
    }

    public StorageAccountMicrosoftEndpoints microsoftEndpoints() {
        return this.microsoftEndpoints;
    }

    public Endpoints withMicrosoftEndpoints(StorageAccountMicrosoftEndpoints microsoftEndpoints) {
        this.microsoftEndpoints = microsoftEndpoints;
        return this;
    }

    public StorageAccountInternetEndpoints internetEndpoints() {
        return this.internetEndpoints;
    }

    public Endpoints withInternetEndpoints(StorageAccountInternetEndpoints internetEndpoints) {
        this.internetEndpoints = internetEndpoints;
        return this;
    }

    public StorageAccountIpv6Endpoints ipv6Endpoints() {
        return this.ipv6Endpoints;
    }

    public Endpoints withIpv6Endpoints(StorageAccountIpv6Endpoints ipv6Endpoints) {
        this.ipv6Endpoints = ipv6Endpoints;
        return this;
    }

    public void validate() {
        if (this.microsoftEndpoints() != null) {
            this.microsoftEndpoints().validate();
        }
        if (this.internetEndpoints() != null) {
            this.internetEndpoints().validate();
        }
        if (this.ipv6Endpoints() != null) {
            this.ipv6Endpoints().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("microsoftEndpoints", (JsonSerializable)this.microsoftEndpoints);
        jsonWriter.writeJsonField("internetEndpoints", (JsonSerializable)this.internetEndpoints);
        jsonWriter.writeJsonField("ipv6Endpoints", (JsonSerializable)this.ipv6Endpoints);
        return jsonWriter.writeEndObject();
    }

    public static Endpoints fromJson(JsonReader jsonReader) throws IOException {
        return (Endpoints)jsonReader.readObject(reader -> {
            Endpoints deserializedEndpoints = new Endpoints();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("blob".equals(fieldName)) {
                    deserializedEndpoints.blob = reader.getString();
                    continue;
                }
                if ("queue".equals(fieldName)) {
                    deserializedEndpoints.queue = reader.getString();
                    continue;
                }
                if ("table".equals(fieldName)) {
                    deserializedEndpoints.table = reader.getString();
                    continue;
                }
                if ("file".equals(fieldName)) {
                    deserializedEndpoints.file = reader.getString();
                    continue;
                }
                if ("web".equals(fieldName)) {
                    deserializedEndpoints.web = reader.getString();
                    continue;
                }
                if ("dfs".equals(fieldName)) {
                    deserializedEndpoints.dfs = reader.getString();
                    continue;
                }
                if ("microsoftEndpoints".equals(fieldName)) {
                    deserializedEndpoints.microsoftEndpoints = StorageAccountMicrosoftEndpoints.fromJson(reader);
                    continue;
                }
                if ("internetEndpoints".equals(fieldName)) {
                    deserializedEndpoints.internetEndpoints = StorageAccountInternetEndpoints.fromJson(reader);
                    continue;
                }
                if ("ipv6Endpoints".equals(fieldName)) {
                    deserializedEndpoints.ipv6Endpoints = StorageAccountIpv6Endpoints.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEndpoints;
        });
    }
}

