/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.models.PermissionScope;
import com.azure.resourcemanager.storage.models.SshPublicKey;
import java.io.IOException;
import java.util.List;

public final class LocalUserProperties
implements JsonSerializable<LocalUserProperties> {
    private List<PermissionScope> permissionScopes;
    private String homeDirectory;
    private List<SshPublicKey> sshAuthorizedKeys;
    private String sid;
    private Boolean hasSharedKey;
    private Boolean hasSshKey;
    private Boolean hasSshPassword;
    private Integer userId;
    private Integer groupId;
    private Boolean allowAclAuthorization;
    private List<Integer> extendedGroups;
    private Boolean isNFSv3Enabled;

    public List<PermissionScope> permissionScopes() {
        return this.permissionScopes;
    }

    public LocalUserProperties withPermissionScopes(List<PermissionScope> permissionScopes) {
        this.permissionScopes = permissionScopes;
        return this;
    }

    public String homeDirectory() {
        return this.homeDirectory;
    }

    public LocalUserProperties withHomeDirectory(String homeDirectory) {
        this.homeDirectory = homeDirectory;
        return this;
    }

    public List<SshPublicKey> sshAuthorizedKeys() {
        return this.sshAuthorizedKeys;
    }

    public LocalUserProperties withSshAuthorizedKeys(List<SshPublicKey> sshAuthorizedKeys) {
        this.sshAuthorizedKeys = sshAuthorizedKeys;
        return this;
    }

    public String sid() {
        return this.sid;
    }

    public Boolean hasSharedKey() {
        return this.hasSharedKey;
    }

    public LocalUserProperties withHasSharedKey(Boolean hasSharedKey) {
        this.hasSharedKey = hasSharedKey;
        return this;
    }

    public Boolean hasSshKey() {
        return this.hasSshKey;
    }

    public LocalUserProperties withHasSshKey(Boolean hasSshKey) {
        this.hasSshKey = hasSshKey;
        return this;
    }

    public Boolean hasSshPassword() {
        return this.hasSshPassword;
    }

    public LocalUserProperties withHasSshPassword(Boolean hasSshPassword) {
        this.hasSshPassword = hasSshPassword;
        return this;
    }

    public Integer userId() {
        return this.userId;
    }

    public Integer groupId() {
        return this.groupId;
    }

    public LocalUserProperties withGroupId(Integer groupId) {
        this.groupId = groupId;
        return this;
    }

    public Boolean allowAclAuthorization() {
        return this.allowAclAuthorization;
    }

    public LocalUserProperties withAllowAclAuthorization(Boolean allowAclAuthorization) {
        this.allowAclAuthorization = allowAclAuthorization;
        return this;
    }

    public List<Integer> extendedGroups() {
        return this.extendedGroups;
    }

    public LocalUserProperties withExtendedGroups(List<Integer> extendedGroups) {
        this.extendedGroups = extendedGroups;
        return this;
    }

    public Boolean isNFSv3Enabled() {
        return this.isNFSv3Enabled;
    }

    public LocalUserProperties withIsNFSv3Enabled(Boolean isNFSv3Enabled) {
        this.isNFSv3Enabled = isNFSv3Enabled;
        return this;
    }

    public void validate() {
        if (this.permissionScopes() != null) {
            this.permissionScopes().forEach(e -> e.validate());
        }
        if (this.sshAuthorizedKeys() != null) {
            this.sshAuthorizedKeys().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("permissionScopes", this.permissionScopes, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("homeDirectory", this.homeDirectory);
        jsonWriter.writeArrayField("sshAuthorizedKeys", this.sshAuthorizedKeys, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeBooleanField("hasSharedKey", this.hasSharedKey);
        jsonWriter.writeBooleanField("hasSshKey", this.hasSshKey);
        jsonWriter.writeBooleanField("hasSshPassword", this.hasSshPassword);
        jsonWriter.writeNumberField("groupId", (Number)this.groupId);
        jsonWriter.writeBooleanField("allowAclAuthorization", this.allowAclAuthorization);
        jsonWriter.writeArrayField("extendedGroups", this.extendedGroups, (writer, element) -> writer.writeInt(element.intValue()));
        jsonWriter.writeBooleanField("isNFSv3Enabled", this.isNFSv3Enabled);
        return jsonWriter.writeEndObject();
    }

    public static LocalUserProperties fromJson(JsonReader jsonReader) throws IOException {
        return (LocalUserProperties)jsonReader.readObject(reader -> {
            LocalUserProperties deserializedLocalUserProperties = new LocalUserProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("permissionScopes".equals(fieldName)) {
                    List permissionScopes;
                    deserializedLocalUserProperties.permissionScopes = permissionScopes = reader.readArray(reader1 -> PermissionScope.fromJson(reader1));
                    continue;
                }
                if ("homeDirectory".equals(fieldName)) {
                    deserializedLocalUserProperties.homeDirectory = reader.getString();
                    continue;
                }
                if ("sshAuthorizedKeys".equals(fieldName)) {
                    List sshAuthorizedKeys;
                    deserializedLocalUserProperties.sshAuthorizedKeys = sshAuthorizedKeys = reader.readArray(reader1 -> SshPublicKey.fromJson(reader1));
                    continue;
                }
                if ("sid".equals(fieldName)) {
                    deserializedLocalUserProperties.sid = reader.getString();
                    continue;
                }
                if ("hasSharedKey".equals(fieldName)) {
                    deserializedLocalUserProperties.hasSharedKey = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("hasSshKey".equals(fieldName)) {
                    deserializedLocalUserProperties.hasSshKey = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("hasSshPassword".equals(fieldName)) {
                    deserializedLocalUserProperties.hasSshPassword = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("userId".equals(fieldName)) {
                    deserializedLocalUserProperties.userId = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("groupId".equals(fieldName)) {
                    deserializedLocalUserProperties.groupId = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("allowAclAuthorization".equals(fieldName)) {
                    deserializedLocalUserProperties.allowAclAuthorization = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("extendedGroups".equals(fieldName)) {
                    List extendedGroups;
                    deserializedLocalUserProperties.extendedGroups = extendedGroups = reader.readArray(reader1 -> reader1.getInt());
                    continue;
                }
                if ("isNFSv3Enabled".equals(fieldName)) {
                    deserializedLocalUserProperties.isNFSv3Enabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLocalUserProperties;
        });
    }
}

