/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.models.ProtectedAppendWritesHistory;
import com.azure.resourcemanager.storage.models.TagProperty;
import java.io.IOException;
import java.util.List;

public final class LegalHoldProperties
implements JsonSerializable<LegalHoldProperties> {
    private Boolean hasLegalHold;
    private List<TagProperty> tags;
    private ProtectedAppendWritesHistory protectedAppendWritesHistory;

    public Boolean hasLegalHold() {
        return this.hasLegalHold;
    }

    public List<TagProperty> tags() {
        return this.tags;
    }

    public LegalHoldProperties withTags(List<TagProperty> tags) {
        this.tags = tags;
        return this;
    }

    public ProtectedAppendWritesHistory protectedAppendWritesHistory() {
        return this.protectedAppendWritesHistory;
    }

    public LegalHoldProperties withProtectedAppendWritesHistory(ProtectedAppendWritesHistory protectedAppendWritesHistory) {
        this.protectedAppendWritesHistory = protectedAppendWritesHistory;
        return this;
    }

    public void validate() {
        if (this.tags() != null) {
            this.tags().forEach(e -> e.validate());
        }
        if (this.protectedAppendWritesHistory() != null) {
            this.protectedAppendWritesHistory().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("tags", this.tags, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("protectedAppendWritesHistory", (JsonSerializable)this.protectedAppendWritesHistory);
        return jsonWriter.writeEndObject();
    }

    public static LegalHoldProperties fromJson(JsonReader jsonReader) throws IOException {
        return (LegalHoldProperties)jsonReader.readObject(reader -> {
            LegalHoldProperties deserializedLegalHoldProperties = new LegalHoldProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("hasLegalHold".equals(fieldName)) {
                    deserializedLegalHoldProperties.hasLegalHold = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    List tags;
                    deserializedLegalHoldProperties.tags = tags = reader.readArray(reader1 -> TagProperty.fromJson(reader1));
                    continue;
                }
                if ("protectedAppendWritesHistory".equals(fieldName)) {
                    deserializedLegalHoldProperties.protectedAppendWritesHistory = ProtectedAppendWritesHistory.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLegalHoldProperties;
        });
    }
}

