/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class RestorePolicyProperties
implements JsonSerializable<RestorePolicyProperties> {
    private boolean enabled;
    private Integer days;
    private OffsetDateTime lastEnabledTime;
    private OffsetDateTime minRestoreTime;

    public boolean enabled() {
        return this.enabled;
    }

    public RestorePolicyProperties withEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public Integer days() {
        return this.days;
    }

    public RestorePolicyProperties withDays(Integer days) {
        this.days = days;
        return this;
    }

    public OffsetDateTime lastEnabledTime() {
        return this.lastEnabledTime;
    }

    public OffsetDateTime minRestoreTime() {
        return this.minRestoreTime;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeNumberField("days", (Number)this.days);
        return jsonWriter.writeEndObject();
    }

    public static RestorePolicyProperties fromJson(JsonReader jsonReader) throws IOException {
        return (RestorePolicyProperties)jsonReader.readObject(reader -> {
            RestorePolicyProperties deserializedRestorePolicyProperties = new RestorePolicyProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("enabled".equals(fieldName)) {
                    deserializedRestorePolicyProperties.enabled = reader.getBoolean();
                    continue;
                }
                if ("days".equals(fieldName)) {
                    deserializedRestorePolicyProperties.days = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("lastEnabledTime".equals(fieldName)) {
                    deserializedRestorePolicyProperties.lastEnabledTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("minRestoreTime".equals(fieldName)) {
                    deserializedRestorePolicyProperties.minRestoreTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRestorePolicyProperties;
        });
    }
}

