/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.models.EncryptionService;
import java.io.IOException;

public final class EncryptionServices
implements JsonSerializable<EncryptionServices> {
    private EncryptionService blob;
    private EncryptionService file;
    private EncryptionService table;
    private EncryptionService queue;

    public EncryptionService blob() {
        return this.blob;
    }

    public EncryptionServices withBlob(EncryptionService blob) {
        this.blob = blob;
        return this;
    }

    public EncryptionService file() {
        return this.file;
    }

    public EncryptionServices withFile(EncryptionService file) {
        this.file = file;
        return this;
    }

    public EncryptionService table() {
        return this.table;
    }

    public EncryptionServices withTable(EncryptionService table) {
        this.table = table;
        return this;
    }

    public EncryptionService queue() {
        return this.queue;
    }

    public EncryptionServices withQueue(EncryptionService queue) {
        this.queue = queue;
        return this;
    }

    public void validate() {
        if (this.blob() != null) {
            this.blob().validate();
        }
        if (this.file() != null) {
            this.file().validate();
        }
        if (this.table() != null) {
            this.table().validate();
        }
        if (this.queue() != null) {
            this.queue().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("blob", (JsonSerializable)this.blob);
        jsonWriter.writeJsonField("file", (JsonSerializable)this.file);
        jsonWriter.writeJsonField("table", (JsonSerializable)this.table);
        jsonWriter.writeJsonField("queue", (JsonSerializable)this.queue);
        return jsonWriter.writeEndObject();
    }

    public static EncryptionServices fromJson(JsonReader jsonReader) throws IOException {
        return (EncryptionServices)jsonReader.readObject(reader -> {
            EncryptionServices deserializedEncryptionServices = new EncryptionServices();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("blob".equals(fieldName)) {
                    deserializedEncryptionServices.blob = EncryptionService.fromJson(reader);
                    continue;
                }
                if ("file".equals(fieldName)) {
                    deserializedEncryptionServices.file = EncryptionService.fromJson(reader);
                    continue;
                }
                if ("table".equals(fieldName)) {
                    deserializedEncryptionServices.table = EncryptionService.fromJson(reader);
                    continue;
                }
                if ("queue".equals(fieldName)) {
                    deserializedEncryptionServices.queue = EncryptionService.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEncryptionServices;
        });
    }
}

