/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class EncryptionScopeKeyVaultProperties
implements JsonSerializable<EncryptionScopeKeyVaultProperties> {
    private String keyUri;
    private String currentVersionedKeyIdentifier;
    private OffsetDateTime lastKeyRotationTimestamp;

    public String keyUri() {
        return this.keyUri;
    }

    public EncryptionScopeKeyVaultProperties withKeyUri(String keyUri) {
        this.keyUri = keyUri;
        return this;
    }

    public String currentVersionedKeyIdentifier() {
        return this.currentVersionedKeyIdentifier;
    }

    public OffsetDateTime lastKeyRotationTimestamp() {
        return this.lastKeyRotationTimestamp;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("keyUri", this.keyUri);
        return jsonWriter.writeEndObject();
    }

    public static EncryptionScopeKeyVaultProperties fromJson(JsonReader jsonReader) throws IOException {
        return (EncryptionScopeKeyVaultProperties)jsonReader.readObject(reader -> {
            EncryptionScopeKeyVaultProperties deserializedEncryptionScopeKeyVaultProperties = new EncryptionScopeKeyVaultProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("keyUri".equals(fieldName)) {
                    deserializedEncryptionScopeKeyVaultProperties.keyUri = reader.getString();
                    continue;
                }
                if ("currentVersionedKeyIdentifier".equals(fieldName)) {
                    deserializedEncryptionScopeKeyVaultProperties.currentVersionedKeyIdentifier = reader.getString();
                    continue;
                }
                if ("lastKeyRotationTimestamp".equals(fieldName)) {
                    deserializedEncryptionScopeKeyVaultProperties.lastKeyRotationTimestamp = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEncryptionScopeKeyVaultProperties;
        });
    }
}

