/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ResourceAccessRule
implements JsonSerializable<ResourceAccessRule> {
    private String tenantId;
    private String resourceId;

    public String tenantId() {
        return this.tenantId;
    }

    public ResourceAccessRule withTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public ResourceAccessRule withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("tenantId", this.tenantId);
        jsonWriter.writeStringField("resourceId", this.resourceId);
        return jsonWriter.writeEndObject();
    }

    public static ResourceAccessRule fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceAccessRule)jsonReader.readObject(reader -> {
            ResourceAccessRule deserializedResourceAccessRule = new ResourceAccessRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tenantId".equals(fieldName)) {
                    deserializedResourceAccessRule.tenantId = reader.getString();
                    continue;
                }
                if ("resourceId".equals(fieldName)) {
                    deserializedResourceAccessRule.resourceId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceAccessRule;
        });
    }
}

