/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.models.ActiveDirectoryPropertiesAccountType;
import java.io.IOException;

public final class ActiveDirectoryProperties
implements JsonSerializable<ActiveDirectoryProperties> {
    private String domainName;
    private String netBiosDomainName;
    private String forestName;
    private String domainGuid;
    private String domainSid;
    private String azureStorageSid;
    private String samAccountName;
    private ActiveDirectoryPropertiesAccountType accountType;
    private static final ClientLogger LOGGER = new ClientLogger(ActiveDirectoryProperties.class);

    public String domainName() {
        return this.domainName;
    }

    public ActiveDirectoryProperties withDomainName(String domainName) {
        this.domainName = domainName;
        return this;
    }

    public String netBiosDomainName() {
        return this.netBiosDomainName;
    }

    public ActiveDirectoryProperties withNetBiosDomainName(String netBiosDomainName) {
        this.netBiosDomainName = netBiosDomainName;
        return this;
    }

    public String forestName() {
        return this.forestName;
    }

    public ActiveDirectoryProperties withForestName(String forestName) {
        this.forestName = forestName;
        return this;
    }

    public String domainGuid() {
        return this.domainGuid;
    }

    public ActiveDirectoryProperties withDomainGuid(String domainGuid) {
        this.domainGuid = domainGuid;
        return this;
    }

    public String domainSid() {
        return this.domainSid;
    }

    public ActiveDirectoryProperties withDomainSid(String domainSid) {
        this.domainSid = domainSid;
        return this;
    }

    public String azureStorageSid() {
        return this.azureStorageSid;
    }

    public ActiveDirectoryProperties withAzureStorageSid(String azureStorageSid) {
        this.azureStorageSid = azureStorageSid;
        return this;
    }

    public String samAccountName() {
        return this.samAccountName;
    }

    public ActiveDirectoryProperties withSamAccountName(String samAccountName) {
        this.samAccountName = samAccountName;
        return this;
    }

    public ActiveDirectoryPropertiesAccountType accountType() {
        return this.accountType;
    }

    public ActiveDirectoryProperties withAccountType(ActiveDirectoryPropertiesAccountType accountType) {
        this.accountType = accountType;
        return this;
    }

    public void validate() {
        if (this.domainName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property domainName in model ActiveDirectoryProperties"));
        }
        if (this.domainGuid() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property domainGuid in model ActiveDirectoryProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("domainName", this.domainName);
        jsonWriter.writeStringField("domainGuid", this.domainGuid);
        jsonWriter.writeStringField("netBiosDomainName", this.netBiosDomainName);
        jsonWriter.writeStringField("forestName", this.forestName);
        jsonWriter.writeStringField("domainSid", this.domainSid);
        jsonWriter.writeStringField("azureStorageSid", this.azureStorageSid);
        jsonWriter.writeStringField("samAccountName", this.samAccountName);
        jsonWriter.writeStringField("accountType", this.accountType == null ? null : this.accountType.toString());
        return jsonWriter.writeEndObject();
    }

    public static ActiveDirectoryProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ActiveDirectoryProperties)jsonReader.readObject(reader -> {
            ActiveDirectoryProperties deserializedActiveDirectoryProperties = new ActiveDirectoryProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("domainName".equals(fieldName)) {
                    deserializedActiveDirectoryProperties.domainName = reader.getString();
                    continue;
                }
                if ("domainGuid".equals(fieldName)) {
                    deserializedActiveDirectoryProperties.domainGuid = reader.getString();
                    continue;
                }
                if ("netBiosDomainName".equals(fieldName)) {
                    deserializedActiveDirectoryProperties.netBiosDomainName = reader.getString();
                    continue;
                }
                if ("forestName".equals(fieldName)) {
                    deserializedActiveDirectoryProperties.forestName = reader.getString();
                    continue;
                }
                if ("domainSid".equals(fieldName)) {
                    deserializedActiveDirectoryProperties.domainSid = reader.getString();
                    continue;
                }
                if ("azureStorageSid".equals(fieldName)) {
                    deserializedActiveDirectoryProperties.azureStorageSid = reader.getString();
                    continue;
                }
                if ("samAccountName".equals(fieldName)) {
                    deserializedActiveDirectoryProperties.samAccountName = reader.getString();
                    continue;
                }
                if ("accountType".equals(fieldName)) {
                    deserializedActiveDirectoryProperties.accountType = ActiveDirectoryPropertiesAccountType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedActiveDirectoryProperties;
        });
    }
}

