/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.sql.models.ManagedInstanceLicenseType;
import com.azure.resourcemanager.sql.models.ManagedInstanceProxyOverride;
import com.azure.resourcemanager.sql.models.ManagedServerCreateMode;
import com.azure.resourcemanager.sql.models.Sku;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.Map;

@JsonFlatten
public class ManagedInstanceUpdate {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ManagedInstanceUpdate.class);
    @JsonProperty(value="sku")
    private Sku sku;
    @JsonProperty(value="tags")
    private Map<String, String> tags;
    @JsonProperty(value="properties.managedInstanceCreateMode")
    private ManagedServerCreateMode managedInstanceCreateMode;
    @JsonProperty(value="properties.fullyQualifiedDomainName", access=JsonProperty.Access.WRITE_ONLY)
    private String fullyQualifiedDomainName;
    @JsonProperty(value="properties.administratorLogin")
    private String administratorLogin;
    @JsonProperty(value="properties.administratorLoginPassword")
    private String administratorLoginPassword;
    @JsonProperty(value="properties.subnetId")
    private String subnetId;
    @JsonProperty(value="properties.state", access=JsonProperty.Access.WRITE_ONLY)
    private String state;
    @JsonProperty(value="properties.licenseType")
    private ManagedInstanceLicenseType licenseType;
    @JsonProperty(value="properties.vCores")
    private Integer vCores;
    @JsonProperty(value="properties.storageSizeInGB")
    private Integer storageSizeInGB;
    @JsonProperty(value="properties.collation")
    private String collation;
    @JsonProperty(value="properties.dnsZone", access=JsonProperty.Access.WRITE_ONLY)
    private String dnsZone;
    @JsonProperty(value="properties.dnsZonePartner")
    private String dnsZonePartner;
    @JsonProperty(value="properties.publicDataEndpointEnabled")
    private Boolean publicDataEndpointEnabled;
    @JsonProperty(value="properties.sourceManagedInstanceId")
    private String sourceManagedInstanceId;
    @JsonProperty(value="properties.restorePointInTime")
    private OffsetDateTime restorePointInTime;
    @JsonProperty(value="properties.proxyOverride")
    private ManagedInstanceProxyOverride proxyOverride;
    @JsonProperty(value="properties.timezoneId")
    private String timezoneId;
    @JsonProperty(value="properties.instancePoolId")
    private String instancePoolId;
    @JsonProperty(value="properties.minimalTlsVersion")
    private String minimalTlsVersion;

    public Sku sku() {
        return this.sku;
    }

    public ManagedInstanceUpdate withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public ManagedInstanceUpdate withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public ManagedServerCreateMode managedInstanceCreateMode() {
        return this.managedInstanceCreateMode;
    }

    public ManagedInstanceUpdate withManagedInstanceCreateMode(ManagedServerCreateMode managedInstanceCreateMode) {
        this.managedInstanceCreateMode = managedInstanceCreateMode;
        return this;
    }

    public String fullyQualifiedDomainName() {
        return this.fullyQualifiedDomainName;
    }

    public String administratorLogin() {
        return this.administratorLogin;
    }

    public ManagedInstanceUpdate withAdministratorLogin(String administratorLogin) {
        this.administratorLogin = administratorLogin;
        return this;
    }

    public String administratorLoginPassword() {
        return this.administratorLoginPassword;
    }

    public ManagedInstanceUpdate withAdministratorLoginPassword(String administratorLoginPassword) {
        this.administratorLoginPassword = administratorLoginPassword;
        return this;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public ManagedInstanceUpdate withSubnetId(String subnetId) {
        this.subnetId = subnetId;
        return this;
    }

    public String state() {
        return this.state;
    }

    public ManagedInstanceLicenseType licenseType() {
        return this.licenseType;
    }

    public ManagedInstanceUpdate withLicenseType(ManagedInstanceLicenseType licenseType) {
        this.licenseType = licenseType;
        return this;
    }

    public Integer vCores() {
        return this.vCores;
    }

    public ManagedInstanceUpdate withVCores(Integer vCores) {
        this.vCores = vCores;
        return this;
    }

    public Integer storageSizeInGB() {
        return this.storageSizeInGB;
    }

    public ManagedInstanceUpdate withStorageSizeInGB(Integer storageSizeInGB) {
        this.storageSizeInGB = storageSizeInGB;
        return this;
    }

    public String collation() {
        return this.collation;
    }

    public ManagedInstanceUpdate withCollation(String collation) {
        this.collation = collation;
        return this;
    }

    public String dnsZone() {
        return this.dnsZone;
    }

    public String dnsZonePartner() {
        return this.dnsZonePartner;
    }

    public ManagedInstanceUpdate withDnsZonePartner(String dnsZonePartner) {
        this.dnsZonePartner = dnsZonePartner;
        return this;
    }

    public Boolean publicDataEndpointEnabled() {
        return this.publicDataEndpointEnabled;
    }

    public ManagedInstanceUpdate withPublicDataEndpointEnabled(Boolean publicDataEndpointEnabled) {
        this.publicDataEndpointEnabled = publicDataEndpointEnabled;
        return this;
    }

    public String sourceManagedInstanceId() {
        return this.sourceManagedInstanceId;
    }

    public ManagedInstanceUpdate withSourceManagedInstanceId(String sourceManagedInstanceId) {
        this.sourceManagedInstanceId = sourceManagedInstanceId;
        return this;
    }

    public OffsetDateTime restorePointInTime() {
        return this.restorePointInTime;
    }

    public ManagedInstanceUpdate withRestorePointInTime(OffsetDateTime restorePointInTime) {
        this.restorePointInTime = restorePointInTime;
        return this;
    }

    public ManagedInstanceProxyOverride proxyOverride() {
        return this.proxyOverride;
    }

    public ManagedInstanceUpdate withProxyOverride(ManagedInstanceProxyOverride proxyOverride) {
        this.proxyOverride = proxyOverride;
        return this;
    }

    public String timezoneId() {
        return this.timezoneId;
    }

    public ManagedInstanceUpdate withTimezoneId(String timezoneId) {
        this.timezoneId = timezoneId;
        return this;
    }

    public String instancePoolId() {
        return this.instancePoolId;
    }

    public ManagedInstanceUpdate withInstancePoolId(String instancePoolId) {
        this.instancePoolId = instancePoolId;
        return this;
    }

    public String minimalTlsVersion() {
        return this.minimalTlsVersion;
    }

    public ManagedInstanceUpdate withMinimalTlsVersion(String minimalTlsVersion) {
        this.minimalTlsVersion = minimalTlsVersion;
        return this;
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
    }
}

