/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.models.AliasPathMetadata;
import com.azure.resourcemanager.resources.models.AliasPattern;
import java.io.IOException;
import java.util.List;

public final class AliasPath
implements JsonSerializable<AliasPath> {
    private String path;
    private List<String> apiVersions;
    private AliasPattern pattern;
    private AliasPathMetadata metadata;

    public String path() {
        return this.path;
    }

    public AliasPath withPath(String path) {
        this.path = path;
        return this;
    }

    public List<String> apiVersions() {
        return this.apiVersions;
    }

    public AliasPath withApiVersions(List<String> apiVersions) {
        this.apiVersions = apiVersions;
        return this;
    }

    public AliasPattern pattern() {
        return this.pattern;
    }

    public AliasPath withPattern(AliasPattern pattern) {
        this.pattern = pattern;
        return this;
    }

    public AliasPathMetadata metadata() {
        return this.metadata;
    }

    public void validate() {
        if (this.pattern() != null) {
            this.pattern().validate();
        }
        if (this.metadata() != null) {
            this.metadata().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("path", this.path);
        jsonWriter.writeArrayField("apiVersions", this.apiVersions, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("pattern", (JsonSerializable)this.pattern);
        return jsonWriter.writeEndObject();
    }

    public static AliasPath fromJson(JsonReader jsonReader) throws IOException {
        return (AliasPath)jsonReader.readObject(reader -> {
            AliasPath deserializedAliasPath = new AliasPath();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("path".equals(fieldName)) {
                    deserializedAliasPath.path = reader.getString();
                    continue;
                }
                if ("apiVersions".equals(fieldName)) {
                    List apiVersions;
                    deserializedAliasPath.apiVersions = apiVersions = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("pattern".equals(fieldName)) {
                    deserializedAliasPath.pattern = AliasPattern.fromJson(reader);
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    deserializedAliasPath.metadata = AliasPathMetadata.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAliasPath;
        });
    }
}

