/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.fluentcore.arm;

import com.azure.core.util.CoreUtils;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.azure.resourcemanager.resources.models.Provider;
import com.azure.resourcemanager.resources.models.ProviderResourceType;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ResourceUtils {
    private ResourceUtils() {
    }

    public static String groupFromResourceId(String id) {
        return id != null ? ResourceId.fromString(id).resourceGroupName() : null;
    }

    public static String subscriptionFromResourceId(String id) {
        return id != null ? ResourceId.fromString(id).subscriptionId() : null;
    }

    public static String resourceProviderFromResourceId(String id) {
        return id != null ? ResourceId.fromString(id).providerNamespace() : null;
    }

    public static String resourceTypeFromResourceId(String id) {
        return id != null ? ResourceId.fromString(id).resourceType() : null;
    }

    public static String parentResourceIdFromResourceId(String id) {
        if (id == null) {
            return null;
        }
        ResourceId resourceId = ResourceId.fromString(id);
        if (resourceId.parent() != null) {
            return ResourceId.fromString(id).parent().id();
        }
        return null;
    }

    public static String parentRelativePathFromResourceId(String id) {
        if (id == null) {
            return null;
        }
        ResourceId parent = ResourceId.fromString(id).parent();
        if (parent != null) {
            return parent.resourceType() + "/" + parent.name();
        }
        return "";
    }

    public static String relativePathFromResourceId(String id) {
        if (id == null) {
            return null;
        }
        String[] paths = id.split("/providers/" + ResourceUtils.resourceProviderFromResourceId(id) + "/", 2);
        if (paths.length == 1) {
            return "";
        }
        return paths[1];
    }

    public static String extractFromResourceId(String id, String identifier) {
        if (id == null || identifier == null) {
            return id;
        }
        Pattern pattern = Pattern.compile(identifier + "/[-\\w._]+");
        Matcher matcher = pattern.matcher(id);
        if (matcher.find()) {
            return matcher.group().split("/")[1];
        }
        return null;
    }

    public static String nameFromResourceId(String id) {
        return id != null ? ResourceId.fromString(id).name() : null;
    }

    public static String defaultApiVersion(String id, Provider provider) {
        if (id == null || provider == null) {
            return null;
        }
        ResourceId resourceId = ResourceId.fromString(id);
        String resourceTypeWithoutNamespace = ResourceUtils.getFullResourceTypeWithoutNamespace(resourceId);
        for (ProviderResourceType prt : provider.resourceTypes()) {
            if (!prt.resourceType().equalsIgnoreCase(resourceTypeWithoutNamespace)) continue;
            return prt.defaultApiVersion() == null ? prt.apiVersions().get(0) : prt.defaultApiVersion();
        }
        ResourceId parent = resourceId.parent();
        if (parent != null && !CoreUtils.isNullOrEmpty((CharSequence)parent.id())) {
            return ResourceUtils.defaultApiVersion(parent.id(), provider);
        }
        return provider.resourceTypes().get(0).apiVersions().get(0);
    }

    public static String constructResourceId(String subscriptionId, String resourceGroupName, String resourceProviderNamespace, String resourceType, String resourceName, String parentResourcePath) {
        String prefixedParentPath = parentResourcePath;
        if (parentResourcePath != null && !parentResourcePath.isEmpty()) {
            prefixedParentPath = "/" + parentResourcePath;
        }
        return String.format("/subscriptions/%s/resourcegroups/%s/providers/%s%s/%s/%s", subscriptionId, resourceGroupName, resourceProviderNamespace, prefixedParentPath, resourceType, resourceName);
    }

    public static String encodeResourceId(String resourceId) {
        if (resourceId == null) {
            return null;
        }
        return resourceId.replaceAll(" ", "%20");
    }

    private static String getFullResourceTypeWithoutNamespace(ResourceId resourceId) {
        return resourceId.fullResourceType().substring(resourceId.fullResourceType().indexOf("/") + 1).toLowerCase(Locale.ROOT);
    }
}

