/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.fluent.models.PolicyExemptionProperties;
import com.azure.resourcemanager.resources.models.AssignmentScopeValidation;
import com.azure.resourcemanager.resources.models.ExemptionCategory;
import com.azure.resourcemanager.resources.models.ResourceSelector;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class PolicyExemptionInner
extends ProxyResource {
    private PolicyExemptionProperties innerProperties = new PolicyExemptionProperties();
    private SystemData systemData;
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(PolicyExemptionInner.class);

    private PolicyExemptionProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public String policyAssignmentId() {
        return this.innerProperties() == null ? null : this.innerProperties().policyAssignmentId();
    }

    public PolicyExemptionInner withPolicyAssignmentId(String policyAssignmentId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PolicyExemptionProperties();
        }
        this.innerProperties().withPolicyAssignmentId(policyAssignmentId);
        return this;
    }

    public List<String> policyDefinitionReferenceIds() {
        return this.innerProperties() == null ? null : this.innerProperties().policyDefinitionReferenceIds();
    }

    public PolicyExemptionInner withPolicyDefinitionReferenceIds(List<String> policyDefinitionReferenceIds) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PolicyExemptionProperties();
        }
        this.innerProperties().withPolicyDefinitionReferenceIds(policyDefinitionReferenceIds);
        return this;
    }

    public ExemptionCategory exemptionCategory() {
        return this.innerProperties() == null ? null : this.innerProperties().exemptionCategory();
    }

    public PolicyExemptionInner withExemptionCategory(ExemptionCategory exemptionCategory) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PolicyExemptionProperties();
        }
        this.innerProperties().withExemptionCategory(exemptionCategory);
        return this;
    }

    public OffsetDateTime expiresOn() {
        return this.innerProperties() == null ? null : this.innerProperties().expiresOn();
    }

    public PolicyExemptionInner withExpiresOn(OffsetDateTime expiresOn) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PolicyExemptionProperties();
        }
        this.innerProperties().withExpiresOn(expiresOn);
        return this;
    }

    public String displayName() {
        return this.innerProperties() == null ? null : this.innerProperties().displayName();
    }

    public PolicyExemptionInner withDisplayName(String displayName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PolicyExemptionProperties();
        }
        this.innerProperties().withDisplayName(displayName);
        return this;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public PolicyExemptionInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PolicyExemptionProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public Object metadata() {
        return this.innerProperties() == null ? null : this.innerProperties().metadata();
    }

    public PolicyExemptionInner withMetadata(Object metadata) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PolicyExemptionProperties();
        }
        this.innerProperties().withMetadata(metadata);
        return this;
    }

    public List<ResourceSelector> resourceSelectors() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceSelectors();
    }

    public PolicyExemptionInner withResourceSelectors(List<ResourceSelector> resourceSelectors) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PolicyExemptionProperties();
        }
        this.innerProperties().withResourceSelectors(resourceSelectors);
        return this;
    }

    public AssignmentScopeValidation assignmentScopeValidation() {
        return this.innerProperties() == null ? null : this.innerProperties().assignmentScopeValidation();
    }

    public PolicyExemptionInner withAssignmentScopeValidation(AssignmentScopeValidation assignmentScopeValidation) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PolicyExemptionProperties();
        }
        this.innerProperties().withAssignmentScopeValidation(assignmentScopeValidation);
        return this;
    }

    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model PolicyExemptionInner"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static PolicyExemptionInner fromJson(JsonReader jsonReader) throws IOException {
        return (PolicyExemptionInner)((Object)jsonReader.readObject(reader -> {
            PolicyExemptionInner deserializedPolicyExemptionInner = new PolicyExemptionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedPolicyExemptionInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedPolicyExemptionInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedPolicyExemptionInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedPolicyExemptionInner.innerProperties = PolicyExemptionProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedPolicyExemptionInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPolicyExemptionInner;
        }));
    }
}

