/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.models.KeyVaultReference;
import java.io.IOException;

public final class KeyVaultParameterReference
implements JsonSerializable<KeyVaultParameterReference> {
    private KeyVaultReference keyVault;
    private String secretName;
    private String secretVersion;
    private static final ClientLogger LOGGER = new ClientLogger(KeyVaultParameterReference.class);

    public KeyVaultReference keyVault() {
        return this.keyVault;
    }

    public KeyVaultParameterReference withKeyVault(KeyVaultReference keyVault) {
        this.keyVault = keyVault;
        return this;
    }

    public String secretName() {
        return this.secretName;
    }

    public KeyVaultParameterReference withSecretName(String secretName) {
        this.secretName = secretName;
        return this;
    }

    public String secretVersion() {
        return this.secretVersion;
    }

    public KeyVaultParameterReference withSecretVersion(String secretVersion) {
        this.secretVersion = secretVersion;
        return this;
    }

    public void validate() {
        if (this.keyVault() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property keyVault in model KeyVaultParameterReference"));
        }
        this.keyVault().validate();
        if (this.secretName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property secretName in model KeyVaultParameterReference"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("keyVault", (JsonSerializable)this.keyVault);
        jsonWriter.writeStringField("secretName", this.secretName);
        jsonWriter.writeStringField("secretVersion", this.secretVersion);
        return jsonWriter.writeEndObject();
    }

    public static KeyVaultParameterReference fromJson(JsonReader jsonReader) throws IOException {
        return (KeyVaultParameterReference)jsonReader.readObject(reader -> {
            KeyVaultParameterReference deserializedKeyVaultParameterReference = new KeyVaultParameterReference();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("keyVault".equals(fieldName)) {
                    deserializedKeyVaultParameterReference.keyVault = KeyVaultReference.fromJson(reader);
                    continue;
                }
                if ("secretName".equals(fieldName)) {
                    deserializedKeyVaultParameterReference.secretName = reader.getString();
                    continue;
                }
                if ("secretVersion".equals(fieldName)) {
                    deserializedKeyVaultParameterReference.secretVersion = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKeyVaultParameterReference;
        });
    }
}

