/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.models.ManagedByTenant;
import com.azure.resourcemanager.resources.models.SubscriptionPolicies;
import com.azure.resourcemanager.resources.models.SubscriptionState;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class SubscriptionInner
implements JsonSerializable<SubscriptionInner> {
    private String id;
    private String subscriptionId;
    private String displayName;
    private String tenantId;
    private SubscriptionState state;
    private SubscriptionPolicies subscriptionPolicies;
    private String authorizationSource;
    private List<ManagedByTenant> managedByTenants;
    private Map<String, String> tags;

    public String id() {
        return this.id;
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public String displayName() {
        return this.displayName;
    }

    public String tenantId() {
        return this.tenantId;
    }

    public SubscriptionState state() {
        return this.state;
    }

    public SubscriptionPolicies subscriptionPolicies() {
        return this.subscriptionPolicies;
    }

    public SubscriptionInner withSubscriptionPolicies(SubscriptionPolicies subscriptionPolicies) {
        this.subscriptionPolicies = subscriptionPolicies;
        return this;
    }

    public String authorizationSource() {
        return this.authorizationSource;
    }

    public SubscriptionInner withAuthorizationSource(String authorizationSource) {
        this.authorizationSource = authorizationSource;
        return this;
    }

    public List<ManagedByTenant> managedByTenants() {
        return this.managedByTenants;
    }

    public SubscriptionInner withManagedByTenants(List<ManagedByTenant> managedByTenants) {
        this.managedByTenants = managedByTenants;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public SubscriptionInner withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public void validate() {
        if (this.subscriptionPolicies() != null) {
            this.subscriptionPolicies().validate();
        }
        if (this.managedByTenants() != null) {
            this.managedByTenants().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("subscriptionPolicies", (JsonSerializable)this.subscriptionPolicies);
        jsonWriter.writeStringField("authorizationSource", this.authorizationSource);
        jsonWriter.writeArrayField("managedByTenants", this.managedByTenants, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static SubscriptionInner fromJson(JsonReader jsonReader) throws IOException {
        return (SubscriptionInner)jsonReader.readObject(reader -> {
            SubscriptionInner deserializedSubscriptionInner = new SubscriptionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSubscriptionInner.id = reader.getString();
                    continue;
                }
                if ("subscriptionId".equals(fieldName)) {
                    deserializedSubscriptionInner.subscriptionId = reader.getString();
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedSubscriptionInner.displayName = reader.getString();
                    continue;
                }
                if ("tenantId".equals(fieldName)) {
                    deserializedSubscriptionInner.tenantId = reader.getString();
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedSubscriptionInner.state = SubscriptionState.fromString(reader.getString());
                    continue;
                }
                if ("subscriptionPolicies".equals(fieldName)) {
                    deserializedSubscriptionInner.subscriptionPolicies = SubscriptionPolicies.fromJson(reader);
                    continue;
                }
                if ("authorizationSource".equals(fieldName)) {
                    deserializedSubscriptionInner.authorizationSource = reader.getString();
                    continue;
                }
                if ("managedByTenants".equals(fieldName)) {
                    List managedByTenants;
                    deserializedSubscriptionInner.managedByTenants = managedByTenants = reader.readArray(reader1 -> ManagedByTenant.fromJson(reader1));
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedSubscriptionInner.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSubscriptionInner;
        });
    }
}

