/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.models.ParameterDefinitionsValue;
import com.azure.resourcemanager.resources.models.PolicyDefinitionGroup;
import com.azure.resourcemanager.resources.models.PolicyDefinitionReference;
import com.azure.resourcemanager.resources.models.PolicyType;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class PolicySetDefinitionProperties
implements JsonSerializable<PolicySetDefinitionProperties> {
    private PolicyType policyType;
    private String displayName;
    private String description;
    private Object metadata;
    private Map<String, ParameterDefinitionsValue> parameters;
    private List<PolicyDefinitionReference> policyDefinitions;
    private List<PolicyDefinitionGroup> policyDefinitionGroups;
    private static final ClientLogger LOGGER = new ClientLogger(PolicySetDefinitionProperties.class);

    public PolicyType policyType() {
        return this.policyType;
    }

    public PolicySetDefinitionProperties withPolicyType(PolicyType policyType) {
        this.policyType = policyType;
        return this;
    }

    public String displayName() {
        return this.displayName;
    }

    public PolicySetDefinitionProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String description() {
        return this.description;
    }

    public PolicySetDefinitionProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public Object metadata() {
        return this.metadata;
    }

    public PolicySetDefinitionProperties withMetadata(Object metadata) {
        this.metadata = metadata;
        return this;
    }

    public Map<String, ParameterDefinitionsValue> parameters() {
        return this.parameters;
    }

    public PolicySetDefinitionProperties withParameters(Map<String, ParameterDefinitionsValue> parameters) {
        this.parameters = parameters;
        return this;
    }

    public List<PolicyDefinitionReference> policyDefinitions() {
        return this.policyDefinitions;
    }

    public PolicySetDefinitionProperties withPolicyDefinitions(List<PolicyDefinitionReference> policyDefinitions) {
        this.policyDefinitions = policyDefinitions;
        return this;
    }

    public List<PolicyDefinitionGroup> policyDefinitionGroups() {
        return this.policyDefinitionGroups;
    }

    public PolicySetDefinitionProperties withPolicyDefinitionGroups(List<PolicyDefinitionGroup> policyDefinitionGroups) {
        this.policyDefinitionGroups = policyDefinitionGroups;
        return this;
    }

    public void validate() {
        if (this.parameters() != null) {
            this.parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.policyDefinitions() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property policyDefinitions in model PolicySetDefinitionProperties"));
        }
        this.policyDefinitions().forEach(e -> e.validate());
        if (this.policyDefinitionGroups() != null) {
            this.policyDefinitionGroups().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("policyDefinitions", this.policyDefinitions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("policyType", this.policyType == null ? null : this.policyType.toString());
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeUntypedField("metadata", this.metadata);
        jsonWriter.writeMapField("parameters", this.parameters, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("policyDefinitionGroups", this.policyDefinitionGroups, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static PolicySetDefinitionProperties fromJson(JsonReader jsonReader) throws IOException {
        return (PolicySetDefinitionProperties)jsonReader.readObject(reader -> {
            PolicySetDefinitionProperties deserializedPolicySetDefinitionProperties = new PolicySetDefinitionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("policyDefinitions".equals(fieldName)) {
                    List policyDefinitions;
                    deserializedPolicySetDefinitionProperties.policyDefinitions = policyDefinitions = reader.readArray(reader1 -> PolicyDefinitionReference.fromJson(reader1));
                    continue;
                }
                if ("policyType".equals(fieldName)) {
                    deserializedPolicySetDefinitionProperties.policyType = PolicyType.fromString(reader.getString());
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedPolicySetDefinitionProperties.displayName = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedPolicySetDefinitionProperties.description = reader.getString();
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    deserializedPolicySetDefinitionProperties.metadata = reader.readUntyped();
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters;
                    deserializedPolicySetDefinitionProperties.parameters = parameters = reader.readMap(reader1 -> ParameterDefinitionsValue.fromJson(reader1));
                    continue;
                }
                if ("policyDefinitionGroups".equals(fieldName)) {
                    List policyDefinitionGroups;
                    deserializedPolicySetDefinitionProperties.policyDefinitionGroups = policyDefinitionGroups = reader.readArray(reader1 -> PolicyDefinitionGroup.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPolicySetDefinitionProperties;
        });
    }
}

