/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.resources.fluent.ResourceNamesClient;
import com.azure.resourcemanager.resources.fluent.models.CheckResourceNameResultInner;
import com.azure.resourcemanager.resources.implementation.SubscriptionClientImpl;
import com.azure.resourcemanager.resources.models.ResourceName;
import reactor.core.publisher.Mono;

public final class ResourceNamesClientImpl
implements ResourceNamesClient {
    private final ClientLogger logger = new ClientLogger(ResourceNamesClientImpl.class);
    private final ResourceNamesService service;
    private final SubscriptionClientImpl client;

    ResourceNamesClientImpl(SubscriptionClientImpl client) {
        this.service = (ResourceNamesService)RestProxy.create(ResourceNamesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CheckResourceNameResultInner>> checkResourceNameWithResponseAsync(ResourceName resourceNameDefinition) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceNameDefinition != null) {
            resourceNameDefinition.validate();
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.checkResourceName(this.client.getEndpoint(), this.client.getApiVersion(), resourceNameDefinition, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<CheckResourceNameResultInner>> checkResourceNameWithResponseAsync(ResourceName resourceNameDefinition, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceNameDefinition != null) {
            resourceNameDefinition.validate();
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.checkResourceName(this.client.getEndpoint(), this.client.getApiVersion(), resourceNameDefinition, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CheckResourceNameResultInner> checkResourceNameAsync(ResourceName resourceNameDefinition) {
        return this.checkResourceNameWithResponseAsync(resourceNameDefinition).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((CheckResourceNameResultInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CheckResourceNameResultInner> checkResourceNameAsync() {
        ResourceName resourceNameDefinition = null;
        return this.checkResourceNameWithResponseAsync(resourceNameDefinition).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((CheckResourceNameResultInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CheckResourceNameResultInner checkResourceName() {
        ResourceName resourceNameDefinition = null;
        return (CheckResourceNameResultInner)this.checkResourceNameAsync(resourceNameDefinition).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CheckResourceNameResultInner> checkResourceNameWithResponse(ResourceName resourceNameDefinition, Context context) {
        return (Response)this.checkResourceNameWithResponseAsync(resourceNameDefinition, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SubscriptionClientRe")
    private static interface ResourceNamesService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/providers/Microsoft.Resources/checkResourceName")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<CheckResourceNameResultInner>> checkResourceName(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") ResourceName var3, @HeaderParam(value="Accept") String var4, Context var5);
    }
}

